/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.linqs.psl.config.Options;
import org.linqs.psl.util.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Parallel {
    private static final Logger log = LoggerFactory.getLogger(Parallel.class);
    private static boolean initialized = false;
    private static int numThreads = -1;
    private static BlockingQueue<Worker<?>> workerQueue;
    private static List<Worker<?>> allWorkers;
    private static ExecutorService pool;
    private static Map<Thread, Map<String, Object>> threadObjects;

    private Parallel() {
    }

    public static synchronized int getNumThreads() {
        if (numThreads == -1) {
            numThreads = Options.PARALLEL_NUM_THREADS.getInt();
        }
        return numThreads;
    }

    public static boolean hasThreadObject(String key) {
        if (!threadObjects.containsKey(Thread.currentThread())) {
            threadObjects.put(Thread.currentThread(), new HashMap());
        }
        return threadObjects.get(Thread.currentThread()).containsKey(key);
    }

    public static Object getThreadObject(String key) {
        if (!threadObjects.containsKey(Thread.currentThread())) {
            threadObjects.put(Thread.currentThread(), new HashMap());
        }
        return threadObjects.get(Thread.currentThread()).get(key);
    }

    public static void putThreadObject(String key, Object value) {
        if (!threadObjects.containsKey(Thread.currentThread())) {
            threadObjects.put(Thread.currentThread(), new HashMap());
        }
        threadObjects.get(Thread.currentThread()).put(key, value);
    }

    public static synchronized RunTimings count(int start, int end, int increment, Worker<Integer> baseWorker) {
        Parallel.initWorkers(baseWorker);
        RunTimings timings = Parallel.countInternal(start, end, increment);
        Parallel.cleanupWorkers();
        return timings;
    }

    public static RunTimings count(int start, int end, Worker<Integer> baseWorker) {
        return Parallel.count(start, end, 1, baseWorker);
    }

    public static RunTimings count(int end, Worker<Integer> baseWorker) {
        return Parallel.count(0, end, 1, baseWorker);
    }

    private static RunTimings countInternal(int start, int end, int increment) {
        int i;
        long iterations = 0L;
        long parentWaitTimeMS = 0L;
        long workerWaitTimeMS = 0L;
        long workerWorkTimeMS = 0L;
        for (i = start; i < end; i += increment) {
            Worker<?> worker = null;
            try {
                long time = System.currentTimeMillis();
                worker = workerQueue.take();
                parentWaitTimeMS += System.currentTimeMillis() - time;
                ++iterations;
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted waiting for worker (" + i + ").");
            }
            if (worker.getException() != null) {
                throw new RuntimeException("Exception on worker.", worker.getException());
            }
            Worker<?> intWorker = worker;
            intWorker.setWork(i, new Integer(i));
            pool.execute(intWorker);
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                long time = System.currentTimeMillis();
                Worker<?> worker = workerQueue.take();
                parentWaitTimeMS += System.currentTimeMillis() - time;
                workerWaitTimeMS += worker.getWaitTime();
                workerWorkTimeMS += worker.getWorkTime();
                if (worker.getException() == null) continue;
                throw new RuntimeException("Exception on worker.", worker.getException());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted waiting for worker (" + i + ").");
            }
        }
        return new RunTimings(iterations, parentWaitTimeMS, workerWaitTimeMS, workerWorkTimeMS);
    }

    public static synchronized <T> RunTimings foreach(Iterable<T> work, Worker<T> baseWorker) {
        Parallel.initWorkers(baseWorker);
        RunTimings timings = Parallel.foreachInternal(work);
        Parallel.cleanupWorkers();
        return timings;
    }

    public static <T> RunTimings foreach(Iterator<T> work, Worker<T> baseWorker) {
        return Parallel.foreach(IteratorUtils.newIterable(work), baseWorker);
    }

    private static <T> RunTimings foreachInternal(Iterable<T> work) {
        long iterations = 0L;
        long parentWaitTimeMS = 0L;
        long workerWaitTimeMS = 0L;
        long workerWorkTimeMS = 0L;
        int count = 0;
        for (T job : work) {
            Worker<?> worker = null;
            try {
                long time = System.currentTimeMillis();
                worker = workerQueue.take();
                parentWaitTimeMS += System.currentTimeMillis() - time;
                ++iterations;
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted waiting for worker (" + count + ").");
            }
            if (worker.getException() != null) {
                throw new RuntimeException("Exception on worker.", worker.getException());
            }
            Worker<?> typedWorker = worker;
            typedWorker.setWork(count, job);
            pool.execute(typedWorker);
            ++count;
        }
        for (int i = 0; i < numThreads; ++i) {
            try {
                long time = System.currentTimeMillis();
                Worker<?> worker = workerQueue.take();
                parentWaitTimeMS += System.currentTimeMillis() - time;
                workerWaitTimeMS += worker.getWaitTime();
                workerWorkTimeMS += worker.getWorkTime();
                if (worker.getException() == null) continue;
                throw new RuntimeException("Exception on worker.", worker.getException());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted waiting for worker (" + i + ").");
            }
        }
        return new RunTimings(iterations, parentWaitTimeMS, workerWaitTimeMS, workerWorkTimeMS);
    }

    private static synchronized void initPool() {
        if (initialized) {
            return;
        }
        workerQueue = new LinkedBlockingQueue();
        allWorkers = new ArrayList(numThreads);
        pool = Executors.newFixedThreadPool(numThreads, new DaemonThreadFactory());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Parallel.shutdown();
            }
        });
        initialized = true;
    }

    private static <T> void initWorkers(Worker<T> baseWorker) {
        Parallel.initPool();
        workerQueue.clear();
        allWorkers.clear();
        for (int i = 0; i < numThreads; ++i) {
            Worker<T> worker = null;
            worker = i == numThreads - 1 ? baseWorker : baseWorker.copy();
            worker.init(i);
            allWorkers.add(worker);
            workerQueue.add(worker);
        }
    }

    private static void cleanupWorkers() {
        for (Worker<?> worker : allWorkers) {
            worker.close();
        }
        allWorkers.clear();
        workerQueue.clear();
    }

    private static void shutdown() {
        Parallel.cleanupWorkers();
        try {
            pool.shutdownNow();
            pool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        workerQueue = null;
        allWorkers = null;
        pool = null;
    }

    private static void freeWorker(Worker<?> worker) {
        workerQueue.add(worker);
    }

    static {
        threadObjects = new ConcurrentHashMap<Thread, Map<String, Object>>();
    }

    public static class RunTimings {
        public final long iterations;
        public final long parentWaitTimeMS;
        public final long workerWaitTimeMS;
        public final long workerWorkTimeMS;

        public RunTimings(long iterations, long parentWaitTimeMS, long workerWaitTimeMS, long workerWorkTimeMS) {
            this.iterations = iterations;
            this.parentWaitTimeMS = parentWaitTimeMS;
            this.workerWaitTimeMS = workerWaitTimeMS;
            this.workerWorkTimeMS = workerWorkTimeMS;
        }

        public String toString() {
            return String.format("Iterations: %d, Parent Wait Time: %d, Worker Wait Time: %d, Worker Work Time: %d", this.iterations, this.parentWaitTimeMS, this.workerWaitTimeMS, this.workerWorkTimeMS);
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultThreadFactory.newThread(r);
            thread.setDaemon(true);
            return thread;
        }
    }

    public static abstract class Worker<T>
    implements Runnable,
    Cloneable {
        protected int id = -1;
        private int index = -1;
        private long waitTimeMS = 0L;
        private long workTimeMS = 0L;
        private T item = null;
        private Exception exception = null;

        public void close() {
        }

        public Worker<T> copy() {
            try {
                return (Worker)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException("Either implement copy(), or support clone() for Workers.", ex);
            }
        }

        public void init(int id) {
            this.id = id;
        }

        public void clearException() {
            this.exception = null;
        }

        public Exception getException() {
            return this.exception;
        }

        public long getWaitTime() {
            return this.waitTimeMS;
        }

        public long getWorkTime() {
            return this.workTimeMS;
        }

        @Override
        public final void run() {
            try {
                if (this.index == -1) {
                    log.warn("Called run() without first calling setWork().");
                    return;
                }
                long time = System.currentTimeMillis();
                this.work(this.index, this.item);
                this.workTimeMS += System.currentTimeMillis() - time;
            }
            catch (Exception ex) {
                log.warn("Caught exception on worker: {}", (Object)this.id);
                this.exception = ex;
            }
            finally {
                this.index = -1;
                this.item = null;
                long time = System.currentTimeMillis();
                Parallel.freeWorker(this);
                this.waitTimeMS += System.currentTimeMillis() - time;
            }
        }

        public final void setWork(int index, T item) {
            this.index = index;
            this.item = item;
        }

        public abstract void work(int var1, T var2);
    }
}

