/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.BaseCTEQuery;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateQuery
extends BaseCTEQuery<UpdateQuery> {
    private SqlObject _table;
    private SqlObjectList<SetClauseObject> _sets = SqlObjectList.create();
    private ComboCondition _condition = ComboCondition.and();

    public UpdateQuery(Table table) {
        this((Object)table);
    }

    public UpdateQuery(Object tableStr) {
        this._table = Converter.toCustomTableSqlObject(tableStr);
    }

    public UpdateQuery addSetClause(Column column, Object value) {
        return this.addCustomSetClause(column, value);
    }

    public UpdateQuery addCustomSetClause(Object column, Object value) {
        this._sets.addObject(new SetClauseObject(Converter.toCustomColumnSqlObject(column), Converter.toColumnSqlObject(value)));
        return this;
    }

    public ComboCondition getWhereClause() {
        return this._condition;
    }

    public UpdateQuery addCondition(Condition newCondition) {
        this._condition.addCondition(newCondition);
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._table.collectSchemaObjects(vContext);
        this._sets.collectSchemaObjects(vContext);
        this._condition.collectSchemaObjects(vContext);
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(false);
        app.append("UPDATE ").append(this._table).append(" SET ").append(this._sets);
        if (!this._condition.isEmpty()) {
            app.append(" WHERE ").append(this._condition);
        }
    }

    private static class SetClauseObject
    extends SqlObject {
        private SqlObject _column;
        private SqlObject _value;

        private SetClauseObject(SqlObject column, SqlObject value) {
            this._column = column;
            this._value = value;
        }

        protected void collectSchemaObjects(ValidationContext vContext) {
            this._column.collectSchemaObjects(vContext);
            this._value.collectSchemaObjects(vContext);
        }

        public void appendTo(AppendableExt app) throws IOException {
            app.append(this._column).append(" = ").append(this._value);
        }
    }
}

