/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.config;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.DataConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.log4j.helpers.OptionConverter;
import org.linqs.psl.util.FileUtils;
import org.linqs.psl.util.Reflection;
import org.linqs.psl.util.RuntimeStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    public static final String CLASS_LIST_PROPS = "classlist.properties";
    public static final String GIT_PROPS = "git.properties";
    public static final String PROJECT_PROPS = "project.properties";
    public static final String PSL_CONFIG = "psl.configuration";
    public static final String PSL_CONFIG_DEFAULT = "psl.properties";
    public static final String CLASS_LIST_KEY = "classlist.classes";
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static DataConfiguration config = null;

    public static void init() {
        String path;
        config = new DataConfiguration(new BaseConfiguration());
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(PROJECT_PROPS);
        if (stream != null) {
            Config.loadResource(stream, PROJECT_PROPS);
        }
        if ((stream = ClassLoader.getSystemClassLoader().getResourceAsStream(GIT_PROPS)) != null) {
            Config.loadResource(stream, GIT_PROPS);
        }
        if ((stream = ClassLoader.getSystemClassLoader().getResourceAsStream(CLASS_LIST_PROPS)) != null) {
            Config.loadResource(stream, CLASS_LIST_PROPS);
        }
        if (FileUtils.isFile(path = OptionConverter.getSystemProperty(PSL_CONFIG, PSL_CONFIG_DEFAULT))) {
            Config.loadResource(path);
            return;
        }
        stream = ClassLoader.getSystemClassLoader().getResourceAsStream(path);
        if (stream != null) {
            Config.loadResource(stream, PSL_CONFIG);
            return;
        }
        log.debug("PSL configuration {} file not found. Only default values will be used unless additional properties are specified.", (Object)path);
    }

    public static void loadResource(InputStream stream, String resourceName) {
        try {
            PropertiesConfiguration props = new PropertiesConfiguration();
            props.read(FileUtils.getInputStreamReader(stream));
            config.append(props);
        }
        catch (IOException | ConfigurationException ex) {
            throw new RuntimeException("Failed to load config resource: " + resourceName, ex);
        }
        log.debug("Configuration stream loaded: {}", (Object)resourceName);
        RuntimeStats.collect();
    }

    public static void loadResource(String path) {
        try {
            PropertiesConfiguration props = new PropertiesConfiguration();
            props.read(FileUtils.getInputStreamReader(path));
            config.append(props);
        }
        catch (IOException | ConfigurationException ex) {
            throw new RuntimeException("Failed to load config resource: " + path, ex);
        }
        log.debug("Configuration file loaded: {}", (Object)path);
        RuntimeStats.collect();
    }

    public static void addProperty(String key, Object value) {
        config.addProperty(key, value);
        log.debug("Added {} to option {}.", value, (Object)key);
        RuntimeStats.collect();
    }

    public static void setProperty(String key, Object value) {
        config.setProperty(key, value);
        log.debug("Set option {} to {}.", (Object)key, value);
        RuntimeStats.collect();
    }

    public static void clearProperty(String key) {
        config.clearProperty(key);
        log.debug("Cleared option {}.", (Object)key);
    }

    public static void clear() {
        config.clear();
        log.debug("Cleared all options in the configuration.");
    }

    public static Object getProperty(String key) {
        Config.logAccess(key, "");
        if (config.containsKey(key)) {
            return config.getProperty(key);
        }
        return null;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getBoolean(key, defaultValue);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getBoolean(key, defaultValue);
    }

    public static Double getDouble(String key, Double defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getDouble(key, defaultValue);
    }

    public static String getString(String key, String defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getString(key, defaultValue);
    }

    public static byte getByte(String key, byte defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getByte(key, defaultValue);
    }

    public static Byte getByte(String key, Byte defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getByte(key, defaultValue);
    }

    public static double getDouble(String key, double defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getDouble(key, defaultValue);
    }

    public static float getFloat(String key, float defaultValue) {
        Config.logAccess(key, Float.valueOf(defaultValue));
        return config.getFloat(key, defaultValue);
    }

    public static Float getFloat(String key, Float defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getFloat(key, defaultValue);
    }

    public static int getInt(String key, int defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getInt(key, defaultValue);
    }

    public static Integer getInteger(String key, Integer defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getInteger(key, defaultValue);
    }

    public static long getLong(String key, long defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getLong(key, defaultValue);
    }

    public static Long getLong(String key, Long defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getLong(key, defaultValue);
    }

    public static short getShort(String key, short defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getShort(key, defaultValue);
    }

    public static Short getShort(String key, Short defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getShort(key, defaultValue);
    }

    public static BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getBigDecimal(key, defaultValue);
    }

    public static BigInteger getBigInteger(String key, BigInteger defaultValue) {
        Config.logAccess(key, defaultValue);
        return config.getBigInteger(key, defaultValue);
    }

    public static List<String> getList(String key, List<String> defaultValue, boolean suppressLogging) {
        if (!suppressLogging) {
            Config.logAccess(key, defaultValue);
        }
        List<Object> configList = config.getList(key, defaultValue);
        ArrayList<String> toReturn = new ArrayList<String>(configList.size());
        for (Object item : configList) {
            toReturn.add((String)item);
        }
        return toReturn;
    }

    public static List<String> getList(String key, List<String> defaultValue) {
        return Config.getList(key, defaultValue, false);
    }

    public static List<String> getList(String key, boolean suppressLogging) {
        return Config.getList(key, new ArrayList<String>(0), suppressLogging);
    }

    public static List<String> getList(String key) {
        return Config.getList(key, new ArrayList<String>(0));
    }

    public static Object getUnloggedProperty(String key) {
        if (config.containsKey(key)) {
            return config.getProperty(key);
        }
        return null;
    }

    public static Object getNewObject(String key, String defaultValue) {
        Config.logAccess(key, defaultValue);
        String className = config.getString(key, defaultValue);
        if (className == null) {
            return null;
        }
        return Reflection.newObject(className);
    }

    public static String asString() {
        StringBuilder string = new StringBuilder();
        Iterator<String> keys = config.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            string.append(key + ": " + config.getProperty(key) + System.lineSeparator());
        }
        return string.toString();
    }

    private static void logAccess(String key, Object defaultValue) {
        if (config.containsKey(key)) {
            log.debug("Found value {} for option {}.", config.getProperty(key), (Object)key);
        } else {
            log.debug("No value found for option {}. Returning default of {}.", (Object)key, defaultValue);
        }
    }

    static {
        Config.init();
    }
}

