/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.atom;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.database.rdbms.RDBMSDatabase;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.grounding.PartialGrounding;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.arithmetic.AbstractArithmeticRule;
import org.linqs.psl.model.term.Constant;

public class LazyAtomManager
extends PersistedAtomManager {
    private final Set<RandomVariableAtom> lazyAtoms;
    private final double activation;

    public LazyAtomManager(Database db) {
        super(db);
        if (!(db instanceof RDBMSDatabase)) {
            throw new IllegalArgumentException("LazyAtomManagers require RDBMSDatabase.");
        }
        this.lazyAtoms = new HashSet<RandomVariableAtom>();
        this.activation = Options.LAM_ACTIVATION_THRESHOLD.getDouble();
    }

    @Override
    public synchronized GroundAtom getAtom(Predicate predicate, Constant ... arguments) {
        GroundAtom atom = this.db.getAtom(predicate, arguments);
        if (!(atom instanceof RandomVariableAtom)) {
            return atom;
        }
        RandomVariableAtom rvAtom = (RandomVariableAtom)atom;
        if (!rvAtom.getPersisted()) {
            this.lazyAtoms.add(rvAtom);
        }
        return rvAtom;
    }

    @Override
    public void reportAccessException(RuntimeException ex, GroundAtom offendingAtom) {
    }

    public Set<RandomVariableAtom> getLazyAtoms() {
        return Collections.unmodifiableSet(this.lazyAtoms);
    }

    public int countActivatableAtoms() {
        int count = 0;
        for (RandomVariableAtom atom : this.lazyAtoms) {
            if (!((double)atom.getValue() >= this.activation)) continue;
            ++count;
        }
        return count;
    }

    public int activateAtoms(List<Rule> rules, GroundRuleStore groundRuleStore) {
        if (this.lazyAtoms.size() == 0) {
            return 0;
        }
        HashSet<RandomVariableAtom> toActivate = new HashSet<RandomVariableAtom>();
        Iterator<RandomVariableAtom> lazyAtomIterator = this.lazyAtoms.iterator();
        while (lazyAtomIterator.hasNext()) {
            RandomVariableAtom atom = lazyAtomIterator.next();
            if (!((double)atom.getValue() >= this.activation)) continue;
            toActivate.add(atom);
            lazyAtomIterator.remove();
        }
        this.activate(toActivate, rules, groundRuleStore);
        return toActivate.size();
    }

    public int activateAtoms(Set<RandomVariableAtom> atoms, List<Rule> rules, GroundRuleStore groundRuleStore) {
        Iterator<RandomVariableAtom> atomIterator = atoms.iterator();
        while (atomIterator.hasNext()) {
            RandomVariableAtom atom = atomIterator.next();
            if (this.lazyAtoms.contains(atom)) continue;
            atomIterator.remove();
        }
        this.activate(atoms, rules, groundRuleStore);
        return atoms.size();
    }

    private void activate(Set<RandomVariableAtom> toActivate, List<Rule> rules, GroundRuleStore groundRuleStore) {
        this.db.commit(toActivate, -1);
        this.addToPersistedCache(toActivate);
        Set<StandardPredicate> lazyPredicates = PartialGrounding.getPartialPredicates(toActivate);
        Set<Rule> lazyRules = PartialGrounding.getPartialRules(rules, lazyPredicates);
        for (Rule lazyRule : lazyRules) {
            if (!lazyRule.supportsGroundingQueryRewriting()) continue;
            PartialGrounding.partialSimpleGround(lazyRule, lazyPredicates, groundRuleStore, this);
        }
        for (StandardPredicate lazyPredicate : lazyPredicates) {
            this.db.moveToWritePartition(lazyPredicate, -1);
        }
        for (Rule lazyRule : lazyRules) {
            if (lazyRule.supportsGroundingQueryRewriting()) continue;
            PartialGrounding.partialComplexGround((AbstractArithmeticRule)lazyRule, groundRuleStore, this);
        }
    }
}

