/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.linqs.psl.database.ResultList;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Variable;

public class RDBMSResultList
implements ResultList {
    private Map<Variable, Integer> varMap = new HashMap<Variable, Integer>();
    private List<Constant[]> results = new ArrayList<Constant[]>();
    private int arity;

    public RDBMSResultList(int arity) {
        this.arity = arity;
    }

    public void addResult(Constant[] res) {
        assert (res.length == this.arity);
        this.results.add(res);
    }

    public void setVariable(Variable var, int pos) {
        if (this.varMap.containsKey(var)) {
            throw new IllegalArgumentException("Variable has already been set!");
        }
        this.varMap.put(var, pos);
    }

    @Override
    public Map<Variable, Integer> getVariableMap() {
        return Collections.unmodifiableMap(this.varMap);
    }

    public int getPos(Variable var) {
        return this.varMap.get(var);
    }

    @Override
    public Constant get(int index, Variable var) {
        return this.results.get(index)[this.getPos(var)];
    }

    @Override
    public Constant[] get(int index) {
        return this.results.get(index);
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public long size() {
        return this.results.size();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Size: ").append(this.size()).append(System.lineSeparator());
        int len = this.getArity();
        for (Constant[] res : this.results) {
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(res[i]);
            }
            s.append(System.lineSeparator());
        }
        s.append("-------");
        return s.toString();
    }

    @Override
    public Iterator<Constant[]> iterator() {
        return this.results.iterator();
    }

    @Override
    public void close() {
        if (this.varMap != null) {
            this.varMap.clear();
            this.varMap = null;
        }
        if (this.results != null) {
            this.results.clear();
            this.results = null;
        }
    }
}

