/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.predicate.model;

import java.util.Map;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.predicate.model.SupportingModel;
import org.linqs.psl.model.term.ConstantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelPredicate
extends StandardPredicate {
    private static final Logger log = LoggerFactory.getLogger(ModelPredicate.class);
    private static final String CONFIG_MIRROR = "mirror";
    protected SupportingModel model;
    private boolean modelLoaded;
    private boolean modelRan;

    protected ModelPredicate(String name, ConstantType[] types, SupportingModel model) {
        super(name, types);
        this.model = model;
        this.modelLoaded = false;
        this.modelRan = false;
    }

    @Override
    public boolean isFixedMirror() {
        return true;
    }

    @Override
    public void close() {
        super.close();
        if (this.model != null) {
            this.model.close();
            this.model = null;
        }
    }

    public void loadModel(Map<String, String> config, String relativeDir) {
        if (config.containsKey(CONFIG_MIRROR)) {
            StandardPredicate mirror = StandardPredicate.get(config.get(CONFIG_MIRROR));
            if (mirror == null) {
                throw new IllegalArgumentException(String.format("Cannot make unknwon predicate (%s) a mirror for %s.", config.get(CONFIG_MIRROR), this));
            }
            this.setMirror(mirror);
            mirror.setMirror(this);
        }
        this.model.load(config, relativeDir);
        this.modelLoaded = true;
    }

    public float getValue(RandomVariableAtom atom) {
        this.checkModel();
        if (!this.modelRan) {
            throw new IllegalStateException("Cannot invoke getValue() before runModel() has been called.");
        }
        float value = this.model.getValue(atom);
        return Math.max(0.0f, Math.min(1.0f, value));
    }

    public void runModel() {
        this.checkModel();
        this.model.run();
        this.modelRan = true;
    }

    public void resetLabels() {
        this.checkModel();
        this.model.resetLabels();
    }

    public float getLabel(RandomVariableAtom atom) {
        this.checkModel();
        return this.model.getLabel(atom);
    }

    public void setLabel(RandomVariableAtom atom, float label) {
        this.checkModel();
        this.model.setLabel(atom, label);
    }

    public void fit() {
        this.checkModel();
        log.trace("Fitting {} ({}).", (Object)this, (Object)this.model);
        this.model.fit();
        log.trace("Done fitting {} ({}).", (Object)this, (Object)this.model);
    }

    public void initialFit() {
        this.checkModel();
        log.trace("Initial fitting {} ({}).", (Object)this, (Object)this.model);
        this.model.initialFit();
        log.trace("Done initial fitting {} ({}).", (Object)this, (Object)this.model);
    }

    private void checkModel() {
        if (!this.modelLoaded) {
            throw new IllegalStateException("ModelPredicate (" + this + ") has not been initialized via loadModel().");
        }
    }

    public static ModelPredicate get(String name) {
        StandardPredicate predicate = StandardPredicate.get(name);
        if (predicate == null) {
            return null;
        }
        if (!(predicate instanceof ModelPredicate)) {
            throw new ClassCastException("Predicate (" + name + ") is not a ModelPredicate.");
        }
        return (ModelPredicate)predicate;
    }

    public static ModelPredicate get(String name, SupportingModel model, ConstantType ... types) {
        ModelPredicate predicate = ModelPredicate.get(name);
        if (predicate == null) {
            return new ModelPredicate(name, types, model);
        }
        StandardPredicate.validateTypes(predicate, types);
        return predicate;
    }
}

