/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.linqs.psl.config.Options;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutableReasoner
extends Reasoner {
    private static final Logger log = LoggerFactory.getLogger(ExecutableReasoner.class);
    protected String executableInputPath;
    protected String executableOutputPath;
    protected String executablePath;
    protected boolean cleanupInput;
    protected boolean cleanupOutput;
    protected String[] args;

    public ExecutableReasoner() {
        this.executablePath = Options.EXECUTABLE_REASONER_PATH.getString();
        this.cleanupInput = Options.EXECUTABLE_CLEAN_INPUT.getBoolean();
        this.cleanupOutput = Options.EXECUTABLE_CLEAN_OUTPUT.getBoolean();
    }

    public ExecutableReasoner(String executablePath, String executableInputPath, String executableOutputPath, String ... args) {
        this.executablePath = executablePath;
        this.executableInputPath = executableInputPath;
        this.executableOutputPath = executableOutputPath;
        this.args = args;
        this.cleanupInput = Options.EXECUTABLE_CLEAN_INPUT.getBoolean();
        this.cleanupOutput = Options.EXECUTABLE_CLEAN_OUTPUT.getBoolean();
    }

    @Override
    public double optimize(TermStore termStore) {
        log.debug("Writing model file: " + this.executableInputPath);
        File modelFile = new File(this.executableInputPath);
        try (BufferedWriter modelWriter = FileUtils.getBufferedWriter(modelFile);){
            this.writeModel(modelWriter, termStore);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write model file: " + this.executableInputPath, ex);
        }
        log.debug("Finished writing model file. Calling reasoner: " + this.executablePath);
        try {
            this.callReasoner();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to call external reasoner: " + this.executablePath, ex);
        }
        log.debug("Reasoner finished. Reading results file: " + this.executableOutputPath);
        File resultsFile = new File(this.executableOutputPath);
        try (BufferedReader resultsReader = FileUtils.getBufferedReader(resultsFile);){
            this.readResults(resultsReader, termStore);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read results file: " + this.executableOutputPath, ex);
        }
        log.debug("Finished reading results file.");
        return -1.0;
    }

    protected void callReasoner() throws IOException {
        String line;
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(this.args));
        command.add(0, this.executablePath);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        BufferedReader stdout = FileUtils.getBufferedReader(proc.getInputStream());
        while ((line = stdout.readLine()) != null) {
            log.debug(line);
        }
        stdout.close();
        int exitValue = -1;
        try {
            exitValue = proc.waitFor();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Failed to wait for executable reasoner.", ex);
        }
        if (exitValue != 0) {
            throw new RuntimeException("Executable exited with unexpected value: " + exitValue);
        }
    }

    @Override
    public void close() {
        if (this.cleanupInput) {
            FileUtils.delete(this.executableInputPath);
        }
        if (this.cleanupOutput) {
            FileUtils.delete(this.executableOutputPath);
        }
    }

    protected abstract void writeModel(BufferedWriter var1, TermStore var2) throws IOException;

    protected abstract void readResults(BufferedReader var1, TermStore var2) throws IOException;
}

