/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.dcd.term;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.reasoner.dcd.term.DCDObjectiveTerm;
import org.linqs.psl.reasoner.dcd.term.DCDStreamingTermStore;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.streaming.StreamingGroundingIterator;
import org.linqs.psl.util.RuntimeStats;

public class DCDStreamingGroundingIterator
extends StreamingGroundingIterator<DCDObjectiveTerm> {
    public DCDStreamingGroundingIterator(DCDStreamingTermStore parentStore, List<Rule> rules, AtomManager atomManager, HyperplaneTermGenerator<DCDObjectiveTerm, GroundAtom> termGenerator, List<DCDObjectiveTerm> termCache, List<DCDObjectiveTerm> termPool, ByteBuffer termBuffer, ByteBuffer volatileBuffer, int pageSize, int numPages) {
        super(parentStore, rules, atomManager, termGenerator, termCache, termPool, termBuffer, volatileBuffer, pageSize, numPages);
    }

    @Override
    protected void flushVolatileCache(String volatilePagePath) {
        int volatileBufferSize = 4 * this.termCache.size();
        if (this.volatileBuffer == null || this.volatileBuffer.capacity() < volatileBufferSize) {
            this.volatileBuffer = ByteBuffer.allocate((int)((double)volatileBufferSize * 1.25));
        }
        this.volatileBuffer.clear();
        for (DCDObjectiveTerm term : this.termCache) {
            this.volatileBuffer.putFloat(term.getLagrange());
        }
        try (FileOutputStream stream = new FileOutputStream(volatilePagePath);){
            stream.write(this.volatileBuffer.array(), 0, volatileBufferSize);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write volatile cache page: " + volatilePagePath, ex);
        }
        RuntimeStats.logDiskWrite(volatileBufferSize);
    }
}

