/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.linqs.psl.config.Options;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.reasoner.function.ConstraintTerm;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.function.FunctionTerm;
import org.linqs.psl.reasoner.function.GeneralFunction;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.ReasonerLocalVariable;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.TermGenerator;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.util.MathUtils;
import org.linqs.psl.util.Parallel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HyperplaneTermGenerator<T extends ReasonerTerm, V extends ReasonerLocalVariable>
implements TermGenerator<T, V> {
    private static final Logger log = LoggerFactory.getLogger(HyperplaneTermGenerator.class);
    protected boolean invertNegativeWeight;
    protected boolean addDeterTerms;
    protected boolean collectiveDeter;
    protected float deterWeight;
    protected float deterEpsilon;
    protected float deterConstant;
    protected boolean mergeConstants;

    public HyperplaneTermGenerator(boolean mergeConstants) {
        this.mergeConstants = mergeConstants;
        this.invertNegativeWeight = Options.HYPERPLANE_TG_INVERT_NEGATIVE_WEIGHTS.getBoolean();
        this.addDeterTerms = Options.HYPERPLANE_TG_ADD_DETER.getBoolean();
        this.collectiveDeter = Options.HYPERPLANE_TG_DETER_COLLECTIVE.getBoolean();
        this.deterWeight = Options.HYPERPLANE_TG_DETER_WEIGHT.getFloat();
        this.deterEpsilon = Options.HYPERPLANE_TG_DETER_EPSILON.getFloat();
        this.deterConstant = Options.HYPERPLANE_TG_DETER_CONSTANT.getFloat();
    }

    @Override
    public long generateTerms(GroundRuleStore ruleStore, TermStore<T, V> termStore) {
        long initialSize = termStore.size();
        termStore.ensureCapacity(initialSize + ruleStore.size());
        HashSet<WeightedRule> rules = new HashSet<WeightedRule>();
        for (GroundRule groundRule : ruleStore.getGroundRules()) {
            if (!(groundRule instanceof WeightedGroundRule)) continue;
            rules.add((WeightedRule)groundRule.getRule());
        }
        for (WeightedRule weightedRule : rules) {
            if (!((double)weightedRule.getWeight() < 0.0)) continue;
            log.warn("Found a rule with a negative weight, but config says not to invert it... skipping: " + weightedRule);
        }
        Parallel.foreach(ruleStore.getGroundRules(), new GeneratorWorker(termStore));
        return termStore.size() - initialSize;
    }

    public int createTerm(GroundRule groundRule, TermStore<T, V> termStore, Collection<T> newTerms, Collection<Hyperplane> newHyperplane) {
        int count = 0;
        Hyperplane<V> hyperplane = null;
        if (groundRule instanceof WeightedGroundRule) {
            GeneralFunction function = ((WeightedGroundRule)groundRule).getFunctionDefinition(this.mergeConstants);
            hyperplane = this.processHyperplane(function, termStore);
            if (hyperplane == null) {
                return 0;
            }
            count = this.createLossTerm(newTerms, termStore, function.isNonNegative(), function.isSquared(), groundRule, hyperplane);
        } else if (groundRule instanceof UnweightedGroundRule) {
            ConstraintTerm constraint = ((UnweightedGroundRule)groundRule).getConstraintDefinition(this.mergeConstants);
            GeneralFunction function = constraint.getFunction();
            hyperplane = this.processHyperplane(function, termStore);
            if (hyperplane == null) {
                return 0;
            }
            hyperplane.setConstant(constraint.getValue() + hyperplane.getConstant());
            count = this.createLinearConstraintTerm(newTerms, termStore, groundRule, hyperplane, constraint.getComparator());
        } else {
            throw new IllegalArgumentException("Unsupported ground rule: " + groundRule);
        }
        if (newHyperplane != null && count > 0) {
            newHyperplane.add(hyperplane);
        }
        return count;
    }

    private Hyperplane<V> processHyperplane(GeneralFunction sum, TermStore<T, V> termStore) {
        Hyperplane<V> hyperplane = new Hyperplane<V>(this.getLocalVariableType(), sum.size(), -1.0f * sum.getConstant());
        for (int i = 0; i < sum.size(); ++i) {
            float coefficient = sum.getCoefficient(i);
            FunctionTerm term = sum.getTerm(i);
            if (term instanceof RandomVariableAtom && ((RandomVariableAtom)term).getPredicate().isFixedMirror()) {
                hyperplane.setConstant(hyperplane.getConstant() - coefficient * term.getValue());
                hyperplane.addIntegratedRVA((RandomVariableAtom)term, -coefficient);
                continue;
            }
            if (term instanceof RandomVariableAtom || !this.mergeConstants && term instanceof ObservedAtom) {
                V variable = termStore.createLocalVariable((GroundAtom)term);
                int localIndex = hyperplane.indexOfVariable(variable);
                if (localIndex != -1) {
                    if (sum.isNonNegative() && !MathUtils.signsMatch(hyperplane.getCoefficient(localIndex), coefficient)) {
                        return null;
                    }
                    hyperplane.appendCoefficient(localIndex, coefficient);
                    continue;
                }
                hyperplane.addTerm(variable, coefficient);
                continue;
            }
            if (term.isConstant()) {
                hyperplane.setConstant(hyperplane.getConstant() - coefficient * term.getValue());
                continue;
            }
            throw new IllegalArgumentException("Unexpected summand: " + sum + "[" + i + "] (" + term + ").");
        }
        if (hyperplane.size() == 0) {
            return null;
        }
        return hyperplane;
    }

    public abstract Class<V> getLocalVariableType();

    public abstract int createLossTerm(Collection<T> var1, TermStore<T, V> var2, boolean var3, boolean var4, GroundRule var5, Hyperplane<V> var6);

    public abstract int createLinearConstraintTerm(Collection<T> var1, TermStore<T, V> var2, GroundRule var3, Hyperplane<V> var4, FunctionComparator var5);

    private class GeneratorWorker
    extends Parallel.Worker<GroundRule> {
        private final TermStore<T, V> termStore;
        private final List<T> newTerms;
        private final List<Hyperplane> newHyperplane;

        public GeneratorWorker(TermStore<T, V> termStore) {
            this.termStore = termStore;
            this.newTerms = new ArrayList(2);
            this.newHyperplane = new ArrayList<Hyperplane>(1);
        }

        public Object clone() {
            return new GeneratorWorker(this.termStore);
        }

        @Override
        public void work(long index, GroundRule rule) {
            boolean negativeWeight;
            this.newTerms.clear();
            this.newHyperplane.clear();
            boolean bl = negativeWeight = rule instanceof WeightedGroundRule && (double)((WeightedGroundRule)rule).getWeight() < 0.0;
            if (negativeWeight) {
                if (!HyperplaneTermGenerator.this.invertNegativeWeight) {
                    return;
                }
                for (GroundRule negatedRule : rule.negate()) {
                    HyperplaneTermGenerator.this.createTerm(negatedRule, this.termStore, this.newTerms, this.newHyperplane);
                    for (ReasonerTerm term : this.newTerms) {
                        this.termStore.add(rule, term, this.newHyperplane.get(0));
                    }
                    this.newTerms.clear();
                    this.newHyperplane.clear();
                }
            } else {
                HyperplaneTermGenerator.this.createTerm(rule, this.termStore, this.newTerms, this.newHyperplane);
                for (ReasonerTerm term : this.newTerms) {
                    this.termStore.add(rule, term, this.newHyperplane.get(0));
                }
                this.newTerms.clear();
                this.newHyperplane.clear();
            }
        }
    }
}

