/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.online;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.atom.OnlineAtomManager;
import org.linqs.psl.grounding.PartialGrounding;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.online.OnlineTermStore;
import org.linqs.psl.reasoner.term.streaming.StreamingGroundingIterator;
import org.linqs.psl.reasoner.term.streaming.StreamingTerm;

public abstract class OnlineGroundingIterator<T extends StreamingTerm>
extends StreamingGroundingIterator<T> {
    private Set<StandardPredicate> onlinePredicates;

    public OnlineGroundingIterator(OnlineTermStore<T> parentStore, List<Rule> rules, AtomManager atomManager, HyperplaneTermGenerator<T, GroundAtom> termGenerator, List<T> termCache, List<T> termPool, ByteBuffer termBuffer, ByteBuffer volatileBuffer, int pageSize, int nextPage) {
        super(parentStore, rules, atomManager, termGenerator, termCache, termPool, termBuffer, volatileBuffer, pageSize, nextPage);
        if (parentStore.isInitialRound()) {
            this.onlinePredicates = null;
            return;
        }
        Set<GroundAtom> obsAtomCache = ((OnlineAtomManager)atomManager).flushNewObservedAtoms();
        Set<GroundAtom> rvAtomCache = ((OnlineAtomManager)atomManager).flushNewRandomVariableAtoms();
        this.onlinePredicates = new HashSet<StandardPredicate>();
        this.onlinePredicates.addAll(PartialGrounding.getPartialPredicates(obsAtomCache));
        this.onlinePredicates.addAll(PartialGrounding.getPartialPredicates(rvAtomCache));
        atomManager.getDatabase().commit(obsAtomCache, -2);
        atomManager.getDatabase().commit(rvAtomCache, -1);
        this.rules = new ArrayList<Rule>(PartialGrounding.getPartialRules(this.rules, this.onlinePredicates));
    }

    @Override
    protected void startGroundingQuery() {
        if (this.parentStore.isInitialRound()) {
            super.startGroundingQuery();
            return;
        }
        this.queryIterable = null;
        this.queryResults = null;
        if (!((Rule)this.rules.get(this.currentRule)).supportsGroundingQueryRewriting()) {
            return;
        }
        this.queryIterable = PartialGrounding.getPartialGroundingResults((Rule)this.rules.get(this.currentRule), this.onlinePredicates, this.atomManager.getDatabase());
        if (this.queryIterable == null) {
            return;
        }
        this.queryResults = this.queryIterable.iterator();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (!this.parentStore.isInitialRound()) {
            for (StandardPredicate onlinePredicate : this.onlinePredicates) {
                this.atomManager.getDatabase().moveToPartition(onlinePredicate, -2, ((OnlineAtomManager)this.atomManager).getOnlineReadPartition());
                this.atomManager.getDatabase().moveToPartition(onlinePredicate, -1, this.atomManager.getDatabase().getWritePartition().getID());
            }
        }
        super.close();
    }
}

