/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.streaming;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.linqs.psl.database.QueryResultIterable;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.rdbms.RDBMSDatabase;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.streaming.StreamingIterator;
import org.linqs.psl.reasoner.term.streaming.StreamingTerm;
import org.linqs.psl.reasoner.term.streaming.StreamingTermStore;
import org.linqs.psl.util.RuntimeStats;

public abstract class StreamingGroundingIterator<T extends StreamingTerm>
implements StreamingIterator<T> {
    public static final double OVERALLOCATION_RATIO = 1.25;
    protected StreamingTermStore<T> parentStore;
    protected HyperplaneTermGenerator<T, GroundAtom> termGenerator;
    protected AtomManager atomManager;
    protected List<Rule> rules;
    protected int currentRule;
    protected List<GroundRule> pendingGroundRules;
    protected List<T> termCache;
    protected List<T> termPool;
    private List<T> newTerms;
    protected ByteBuffer termBuffer;
    protected ByteBuffer volatileBuffer;
    protected long termCount;
    protected QueryResultIterable queryIterable;
    protected Iterator<Constant[]> queryResults;
    protected boolean closed;
    protected T nextTerm;
    protected int pageSize;
    protected int nextPage;

    public StreamingGroundingIterator(StreamingTermStore<T> parentStore, List<Rule> rules, AtomManager atomManager, HyperplaneTermGenerator<T, GroundAtom> termGenerator, List<T> termCache, List<T> termPool, ByteBuffer termBuffer, ByteBuffer volatileBuffer, int pageSize) {
        this(parentStore, rules, atomManager, termGenerator, termCache, termPool, termBuffer, volatileBuffer, pageSize, 0);
    }

    public StreamingGroundingIterator(StreamingTermStore<T> parentStore, List<Rule> rules, AtomManager atomManager, HyperplaneTermGenerator<T, GroundAtom> termGenerator, List<T> termCache, List<T> termPool, ByteBuffer termBuffer, ByteBuffer volatileBuffer, int pageSize, int nextPage) {
        this.parentStore = parentStore;
        this.termGenerator = termGenerator;
        this.atomManager = atomManager;
        this.rules = rules;
        this.currentRule = -1;
        this.pendingGroundRules = new ArrayList<GroundRule>();
        this.termCache = termCache;
        this.termPool = termPool;
        this.newTerms = new ArrayList<T>();
        this.termBuffer = termBuffer;
        this.volatileBuffer = volatileBuffer;
        this.pageSize = pageSize;
        this.nextPage = nextPage;
        this.termCount = 0L;
        this.queryIterable = null;
        this.queryResults = null;
        this.closed = false;
        this.nextTerm = null;
    }

    @Override
    public boolean hasNext() {
        if (this.nextTerm != null) {
            throw new IllegalStateException("hasNext() was called twice in a row. Call next() directly after hasNext() == true.");
        }
        if (this.closed) {
            return false;
        }
        this.nextTerm = this.fetchNextTerm();
        if (this.nextTerm == null) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (this.nextTerm == null) {
            throw new IllegalStateException("Called next() when hasNext() == false (or before the first hasNext() call).");
        }
        T term = this.nextTerm;
        this.nextTerm = null;
        return term;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private T fetchNextTerm() {
        if (this.termCache.size() >= this.pageSize) {
            this.flushCache();
        }
        if (this.newTerms.size() == 0) {
            this.fetchNextTermFromRule();
        }
        StreamingTerm term = null;
        if (this.newTerms.size() > 0) {
            term = (StreamingTerm)this.newTerms.remove(0);
            this.termCache.add(term);
            ++this.termCount;
        }
        if (term != null && this.termCache.size() > this.termPool.size()) {
            this.termPool.add(term);
        }
        return (T)term;
    }

    private void fetchNextTermFromRule() {
        this.newTerms.clear();
        while (this.newTerms.size() == 0) {
            GroundRule groundRule = this.fetchNextGroundRule();
            if (groundRule == null) {
                return;
            }
            this.termGenerator.createTerm(groundRule, this.parentStore, this.newTerms, null);
        }
    }

    private GroundRule fetchNextGroundRule() {
        while (this.pendingGroundRules.size() > 0) {
            GroundRule groundRule = this.pendingGroundRules.remove(this.pendingGroundRules.size() - 1);
            if (groundRule == null) continue;
            return groundRule;
        }
        while (this.queryResults != null && this.queryResults.hasNext()) {
            Constant[] tuple = this.queryResults.next();
            this.rules.get(this.currentRule).ground(tuple, this.queryIterable.getVariableMap(), this.atomManager, this.pendingGroundRules);
            while (this.pendingGroundRules.size() > 0) {
                GroundRule groundRule = this.pendingGroundRules.remove(this.pendingGroundRules.size() - 1);
                if (groundRule == null) continue;
                return groundRule;
            }
        }
        ++this.currentRule;
        if (this.currentRule >= this.rules.size()) {
            return null;
        }
        this.startGroundingQuery();
        return this.fetchNextGroundRule();
    }

    protected void startGroundingQuery() {
        this.queryIterable = ((RDBMSDatabase)this.atomManager.getDatabase()).executeQueryIterator(this.rules.get(this.currentRule).getGroundingQuery(this.atomManager));
        this.queryResults = this.queryIterable.iterator();
    }

    protected void flushCache() {
        if (this.termCache.size() == 0) {
            return;
        }
        String termPagePath = this.parentStore.getTermPagePath(this.nextPage);
        String volatilePagePath = this.parentStore.getVolatilePagePath(this.nextPage);
        this.writeFullPage(termPagePath, volatilePagePath);
        ++this.nextPage;
    }

    protected void flushTermCache(String termPagePath) {
        int termsSize = 0;
        for (Object term : this.termCache) {
            termsSize += term.fixedByteSize();
        }
        int termBufferSize = termsSize + 8;
        if (this.termBuffer == null || this.termBuffer.capacity() < termBufferSize) {
            this.termBuffer = ByteBuffer.allocate((int)((double)termBufferSize * 1.25));
        }
        this.termBuffer.clear();
        this.termBuffer.putInt(termsSize);
        this.termBuffer.putInt(this.termCache.size());
        for (StreamingTerm term : this.termCache) {
            term.writeFixedValues(this.termBuffer);
        }
        try (FileOutputStream stream = new FileOutputStream(termPagePath);){
            stream.write(this.termBuffer.array(), 0, termBufferSize);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write term cache page: " + termPagePath, ex);
        }
        RuntimeStats.logDiskWrite(termBufferSize);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flushCache();
        if (this.queryIterable != null) {
            this.queryIterable.close();
            this.queryIterable = null;
            this.queryResults = null;
        }
        this.termCache.clear();
        this.parentStore.groundingIterationComplete(this.termCount, this.nextPage, this.termBuffer, this.volatileBuffer);
    }

    protected void flushVolatileCache(String volatilePagePath) {
        if (this.volatileBuffer == null) {
            this.volatileBuffer = ByteBuffer.allocate(0);
        }
    }

    protected void writeFullPage(String termPagePath, String volatilePagePath) {
        this.flushTermCache(termPagePath);
        this.flushVolatileCache(volatilePagePath);
        this.termCache.clear();
    }
}

