/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference.online;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import org.linqs.psl.application.inference.online.messages.ModelInformation;
import org.linqs.psl.application.inference.online.messages.OnlineMessage;
import org.linqs.psl.application.inference.online.messages.actions.controls.Exit;
import org.linqs.psl.application.inference.online.messages.actions.controls.Stop;
import org.linqs.psl.application.inference.online.messages.responses.OnlineResponse;
import org.linqs.psl.config.Options;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.util.Logger;

public class OnlineClient
implements Runnable {
    private static final Logger log = Logger.getLogger(OnlineClient.class);
    private List<OnlineResponse> serverResponses;
    private BlockingQueue<OnlineMessage> actionQueue;
    private CountDownLatch modelRegistrationLatch;
    private String hostname;
    private int port;

    public OnlineClient(BlockingQueue<OnlineMessage> actionQueue, List<OnlineResponse> serverResponses, CountDownLatch modelRegistrationLatch) {
        this.serverResponses = serverResponses;
        this.actionQueue = actionQueue;
        this.hostname = Options.ONLINE_HOST.getString();
        this.port = Options.ONLINE_PORT_NUMBER.getInt();
        this.modelRegistrationLatch = modelRegistrationLatch;
    }

    @Override
    public void run() {
        OnlineMessage onlineAction = null;
        try (Socket server = new Socket(this.hostname, this.port);
             ObjectOutputStream socketOutputStream = new ObjectOutputStream(server.getOutputStream());
             ObjectInputStream socketInputStream = new ObjectInputStream(server.getInputStream());){
            this.registerServerModel(socketInputStream);
            this.modelRegistrationLatch.countDown();
            ServerConnectionThread serverConnectionThread = new ServerConnectionThread(socketInputStream, this.serverResponses);
            serverConnectionThread.start();
            do {
                try {
                    onlineAction = this.actionQueue.take();
                }
                catch (InterruptedException ex) {
                    log.warn("Interrupted while taking an online action from the queue. Stopping client session and not waiting for server responses.", ex);
                    socketOutputStream.writeObject(new Exit());
                    socketInputStream.close();
                    if (socketInputStream != null) {
                        if (var7_13 != null) {
                            try {
                                socketInputStream.close();
                            }
                            catch (Throwable throwable) {
                                var7_13.addSuppressed(throwable);
                            }
                        } else {
                            socketInputStream.close();
                        }
                    }
                    if (socketOutputStream != null) {
                        if (var5_9 != null) {
                            try {
                                socketOutputStream.close();
                            }
                            catch (Throwable throwable) {
                                var5_9.addSuppressed(throwable);
                            }
                        } else {
                            socketOutputStream.close();
                        }
                    }
                    if (server != null) {
                        if (var3_5 != null) {
                            try {
                                server.close();
                            }
                            catch (Throwable throwable) {
                                var3_5.addSuppressed(throwable);
                            }
                        } else {
                            server.close();
                        }
                    }
                    return;
                }
                log.trace("Sending Action {}", onlineAction);
                socketOutputStream.writeObject(onlineAction);
            } while (!(onlineAction instanceof Exit) && !(onlineAction instanceof Stop));
            serverConnectionThread.join();
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InterruptedException ex) {
            log.warn("Client session interrupted. Client stopped.");
        }
    }

    private void registerServerModel(ObjectInputStream socketInputStream) throws IOException, ClassNotFoundException {
        ModelInformation modelInformation = (ModelInformation)socketInputStream.readObject();
        for (Predicate predicate : modelInformation.getPredicates()) {
            Predicate.registerPredicate(predicate);
            log.trace("Registered predicate: " + Predicate.get(predicate.getName()).toString() + " Client Hash: " + Predicate.get(predicate.getName()).hashCode() + " Server Hash: " + predicate.hashCode());
        }
    }

    private static class ServerConnectionThread
    extends Thread {
        private ObjectInputStream inputStream;
        private List<OnlineResponse> serverResponses;

        public ServerConnectionThread(ObjectInputStream inputStream, List<OnlineResponse> serverResponses) {
            this.inputStream = inputStream;
            this.serverResponses = serverResponses;
        }

        @Override
        public void run() {
            OnlineResponse response = null;
            while (true) {
                try {
                    response = (OnlineResponse)this.inputStream.readObject();
                }
                catch (EOFException ex) {
                    break;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                catch (ClassNotFoundException ex) {
                    log.warn("Unable to deserialized last OnlineResponse from server.");
                }
                this.serverResponses.add(response);
            }
        }
    }
}

