/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference.online;

import java.util.List;
import java.util.Set;
import org.linqs.psl.application.inference.InferenceApplication;
import org.linqs.psl.application.inference.online.OnlineServer;
import org.linqs.psl.application.inference.online.messages.OnlineMessage;
import org.linqs.psl.application.inference.online.messages.actions.controls.Stop;
import org.linqs.psl.application.inference.online.messages.actions.controls.Sync;
import org.linqs.psl.application.inference.online.messages.actions.controls.WriteInferredPredicates;
import org.linqs.psl.application.inference.online.messages.actions.model.AddAtom;
import org.linqs.psl.application.inference.online.messages.actions.model.DeleteAtom;
import org.linqs.psl.application.inference.online.messages.actions.model.GetAtom;
import org.linqs.psl.application.inference.online.messages.actions.model.ObserveAtom;
import org.linqs.psl.application.inference.online.messages.actions.model.UpdateObservation;
import org.linqs.psl.application.inference.online.messages.actions.template.ActivateRule;
import org.linqs.psl.application.inference.online.messages.actions.template.AddRule;
import org.linqs.psl.application.inference.online.messages.actions.template.DeactivateRule;
import org.linqs.psl.application.inference.online.messages.actions.template.DeleteRule;
import org.linqs.psl.application.inference.online.messages.responses.ActionStatus;
import org.linqs.psl.application.inference.online.messages.responses.GetAtomResponse;
import org.linqs.psl.application.learning.weight.TrainingMap;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.OnlineAtomManager;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.evaluation.statistics.Evaluator;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.reasoner.term.online.OnlineTermStore;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.StringUtils;

public abstract class OnlineInference
extends InferenceApplication {
    private static final Logger log = Logger.getLogger(OnlineInference.class);
    private OnlineServer server;
    private boolean modelUpdates;
    private boolean stopped;
    private double objective;
    private List<Evaluator> evaluators;
    private TrainingMap trainingMap;
    private Set<StandardPredicate> evaluationPredicates;

    protected OnlineInference(List<Rule> rules, Database database) {
        super(rules, database);
    }

    protected OnlineInference(List<Rule> rules, Database database, boolean relaxHardConstraints) {
        super(rules, database, relaxHardConstraints);
    }

    @Override
    protected void initialize() {
        this.stopped = false;
        this.modelUpdates = true;
        this.objective = 0.0;
        this.evaluators = null;
        this.trainingMap = null;
        this.evaluationPredicates = null;
        this.startServer();
        super.initialize();
        this.termStore.ensureVariableCapacity(this.atomManager.getCachedRVACount() + this.atomManager.getCachedObsCount());
    }

    @Override
    protected PersistedAtomManager createAtomManager(Database database) {
        return new OnlineAtomManager(database, this.initialValue);
    }

    @Override
    public void close() {
        this.stopped = true;
        this.closeServer();
        super.close();
    }

    private void closeServer() {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    private void startServer() {
        this.server = new OnlineServer(this.rules);
        this.server.start();
    }

    protected void executeAction(OnlineMessage action) {
        String response = null;
        if (action.getClass() == AddAtom.class) {
            response = this.doAddAtom((AddAtom)action);
        } else if (action.getClass() == DeleteAtom.class) {
            response = this.doDeleteAtom((DeleteAtom)action);
        } else if (action.getClass() == ObserveAtom.class) {
            response = this.doObserveAtom((ObserveAtom)action);
        } else if (action.getClass() == UpdateObservation.class) {
            response = this.doUpdateObservation((UpdateObservation)action);
        } else if (action.getClass() == GetAtom.class) {
            response = this.doGetAtom((GetAtom)action);
        } else if (action.getClass() == ActivateRule.class) {
            response = this.doActivateRule((ActivateRule)action);
        } else if (action.getClass() == AddRule.class) {
            response = this.doAddRule((AddRule)action);
        } else if (action.getClass() == DeactivateRule.class) {
            response = this.doDeactivateRule((DeactivateRule)action);
        } else if (action.getClass() == DeleteRule.class) {
            response = this.doDeleteRule((DeleteRule)action);
        } else if (action.getClass() == WriteInferredPredicates.class) {
            response = this.doWriteInferredPredicates((WriteInferredPredicates)action);
        } else if (action.getClass() == Sync.class) {
            response = this.doSync();
        } else if (action.getClass() == Stop.class) {
            response = this.doStop();
        } else {
            throw new IllegalArgumentException("Unsupported action: " + action.getClass().getName() + ".");
        }
        this.server.onActionExecution(action, new ActionStatus(action, true, response));
    }

    protected String doAddAtom(AddAtom action) {
        GroundAtom atom = null;
        if (this.atomManager.getDatabase().hasAtom(action.getPredicate(), action.getArguments())) {
            atom = this.deleteAtom(action.getPredicate(), action.getArguments());
            ((OnlineTermStore)this.termStore).deleteLocalVariable(atom);
        }
        if (action.getPartitionName().equalsIgnoreCase("READ")) {
            atom = ((OnlineAtomManager)this.atomManager).addObservedAtom(action.getPredicate(), action.getValue(), action.getArguments());
        } else {
            atom = ((OnlineAtomManager)this.atomManager).addRandomVariableAtom(action.getPredicate(), action.getValue(), action.getArguments());
            if (this.trainingMap != null) {
                this.trainingMap.addRandomVariableTargetAtom((RandomVariableAtom)atom);
            }
        }
        ((OnlineTermStore)this.termStore).createLocalVariable(atom);
        this.modelUpdates = true;
        return String.format("Added atom: %s", atom.toStringWithValue());
    }

    protected String doDeleteAtom(DeleteAtom action) {
        if (!this.atomManager.getDatabase().hasAtom(action.getPredicate(), action.getArguments())) {
            return String.format("Atom: %s(%s) does not exist in atom manager.", action.getPredicate(), StringUtils.join(", ", (Object[])action.getArguments()));
        }
        GroundAtom atom = this.deleteAtom(action.getPredicate(), action.getArguments());
        ((OnlineTermStore)this.termStore).deleteLocalVariable(atom);
        this.modelUpdates = true;
        return String.format("Deleted atom: %s", atom);
    }

    protected String doObserveAtom(ObserveAtom action) {
        if (!this.atomManager.getDatabase().hasAtom(action.getPredicate(), action.getArguments())) {
            return String.format("Atom: %s(%s) does not exist in atom manager.", action.getPredicate(), StringUtils.join(", ", (Object[])action.getArguments()));
        }
        GroundAtom atom = this.atomManager.getAtom(action.getPredicate(), action.getArguments());
        if (!(atom instanceof RandomVariableAtom)) {
            return String.format("Atom: %s(%s) already observed.", action.getPredicate(), StringUtils.join(", ", (Object[])action.getArguments()));
        }
        this.deleteAtom(action.getPredicate(), action.getArguments());
        ObservedAtom observedAtom = ((OnlineAtomManager)this.atomManager).addObservedAtom(action.getPredicate(), action.getValue(), false, action.getArguments());
        ((OnlineTermStore)this.termStore).updateLocalVariable(observedAtom, action.getValue());
        this.modelUpdates = true;
        return String.format("Observed atom: %s => %s", atom.toStringWithValue(), observedAtom.toStringWithValue());
    }

    protected String doUpdateObservation(UpdateObservation action) {
        if (!this.atomManager.getDatabase().hasAtom(action.getPredicate(), action.getArguments())) {
            return String.format("Atom: %s(%s) does not exist in atom manager.", action.getPredicate(), StringUtils.join(", ", (Object[])action.getArguments()));
        }
        GroundAtom atom = this.atomManager.getAtom(action.getPredicate(), action.getArguments());
        if (!(atom instanceof ObservedAtom)) {
            return String.format("Atom: %s is not an observation.", atom);
        }
        float oldAtomValue = atom.getValue();
        ((OnlineTermStore)this.termStore).updateLocalVariable((ObservedAtom)atom, action.getValue());
        ((ObservedAtom)atom)._assumeValue(action.getValue());
        this.modelUpdates = true;
        return String.format("Updated atom: %s: %f => %f", atom, Float.valueOf(oldAtomValue), Float.valueOf(atom.getValue()));
    }

    protected String doGetAtom(GetAtom action) {
        if (!((OnlineAtomManager)this.atomManager).hasAtom(action.getPredicate(), action.getArguments())) {
            this.server.onActionExecution(action, new GetAtomResponse(action, -1.0));
            return String.format("Atom: %s(%s) not found.", action.getPredicate(), StringUtils.join(", ", (Object[])action.getArguments()));
        }
        this.optimize();
        double atomValue = this.atomManager.getAtom(action.getPredicate(), action.getArguments()).getValue();
        this.server.onActionExecution(action, new GetAtomResponse(action, atomValue));
        return String.format("Atom: %s(%s) found. Returned to client.", action.getPredicate(), StringUtils.join(", ", (Object[])action.getArguments()));
    }

    protected String doActivateRule(ActivateRule action) {
        if (action.isNewRule()) {
            return String.format("Rule: %s does not exist in model.", action.getRule());
        }
        ((OnlineTermStore)this.termStore).activateRule(action.getRule());
        this.modelUpdates = true;
        return String.format("Activated rule: %s", action.getRule());
    }

    protected String doAddRule(AddRule action) {
        if (!action.isNewRule()) {
            return String.format("Rule: %s already exists in model.", action.getRule());
        }
        ((OnlineTermStore)this.termStore).addRule(action.getRule());
        this.modelUpdates = true;
        return String.format("Added rule: %s", action.getRule());
    }

    protected String doDeactivateRule(DeactivateRule action) {
        if (action.isNewRule()) {
            return String.format("Rule: %s does not exist in model.", action.getRule());
        }
        ((OnlineTermStore)this.termStore).deactivateRule(action.getRule());
        this.modelUpdates = true;
        return String.format("Deactivated rule: %s", action.getRule());
    }

    protected String doDeleteRule(DeleteRule action) {
        if (action.isNewRule()) {
            return String.format("Rule: %s does not exist in model.", action.getRule());
        }
        ((OnlineTermStore)this.termStore).deleteRule(action.getRule());
        action.getRule().unregister();
        this.modelUpdates = true;
        return String.format("Deleted rule: %s", action.getRule());
    }

    protected String doWriteInferredPredicates(WriteInferredPredicates action) {
        String response = null;
        this.optimize();
        if (action.getOutputDirectoryPath() != null) {
            log.info("Writing inferred predicates to file: " + action.getOutputDirectoryPath());
            this.database.outputRandomVariableAtoms(action.getOutputDirectoryPath());
            response = "Wrote inferred predicates to file: " + action.getOutputDirectoryPath();
        } else {
            log.info("Writing inferred predicates to output stream.");
            this.database.outputRandomVariableAtoms();
            response = "Wrote inferred predicates to output stream.";
        }
        return response;
    }

    protected String doSync() {
        this.optimize();
        return "OnlinePSL inference synced.";
    }

    protected String doStop() {
        this.stopped = true;
        return "OnlinePSL inference stopped.";
    }

    private GroundAtom deleteAtom(StandardPredicate predicate, Constant[] arguments) {
        GroundAtom atom = ((OnlineAtomManager)this.atomManager).deleteAtom(predicate, arguments);
        if (atom == null) {
            return null;
        }
        if (this.trainingMap != null) {
            this.trainingMap.deleteAtom(atom);
        }
        return atom;
    }

    private void optimize() {
        if (!this.modelUpdates) {
            return;
        }
        log.trace("Optimization Start");
        this.objective = this.reasoner.optimize(this.termStore, this.evaluators, this.trainingMap, this.evaluationPredicates);
        log.trace("Optimization End");
        this.modelUpdates = false;
    }

    @Override
    public double internalInference(List<Evaluator> evaluators, TrainingMap trainingMap, Set<StandardPredicate> evaluationPredicates) {
        this.evaluators = evaluators;
        this.trainingMap = trainingMap;
        this.evaluationPredicates = evaluationPredicates;
        this.optimize();
        while (!this.stopped) {
            OnlineMessage action = this.server.getAction();
            if (action == null) continue;
            try {
                log.trace(String.format("Executing action: %s", action));
                this.executeAction(action);
            }
            catch (IllegalArgumentException ex) {
                this.server.onActionExecution(action, new ActionStatus(action, false, ex.getMessage()));
            }
            catch (RuntimeException ex) {
                this.server.onActionExecution(action, new ActionStatus(action, false, ex.getMessage()));
                throw new RuntimeException(String.format("Critically failed to execute action: %s", action), ex);
            }
        }
        this.closeServer();
        return this.objective;
    }
}

