/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.atom;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.predicate.GroundingOnlyPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.rule.arithmetic.expression.SummationAtomOrAtom;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.model.term.DoubleAttribute;
import org.linqs.psl.model.term.IntegerAttribute;
import org.linqs.psl.model.term.LongAttribute;
import org.linqs.psl.model.term.StringAttribute;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.UniqueIntID;
import org.linqs.psl.model.term.UniqueStringID;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.util.HashCode;

public abstract class Atom
implements Formula,
SummationAtomOrAtom {
    protected Predicate predicate;
    protected Term[] arguments;
    protected int hashcode;

    protected Atom(Predicate predicate, Term[] args) {
        this.init(true, true, predicate, args);
    }

    protected void init(boolean copyArgs, boolean doValidation, Predicate predicate, Term[] args) {
        this.predicate = predicate;
        this.arguments = copyArgs ? Arrays.copyOf(args, args.length) : args;
        if (doValidation) {
            this.validate();
        }
        this.hashcode = HashCode.build(HashCode.build(predicate), this.arguments);
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public int getArity() {
        return this.predicate.getArity();
    }

    public Term[] getArguments() {
        return this.arguments;
    }

    public Set<Variable> getVariables() {
        HashSet<Variable> variables = new HashSet<Variable>();
        for (Term term : this.arguments) {
            if (!(term instanceof Variable)) continue;
            variables.add((Variable)term);
        }
        return variables;
    }

    @Override
    public Formula getDNF() {
        return this;
    }

    @Override
    public Set<Atom> getAtoms(Set<Atom> atoms) {
        atoms.add(this);
        return atoms;
    }

    public boolean isManaged() {
        return true;
    }

    private void validate() {
        if (this.predicate.getArity() != this.arguments.length) {
            throw new IllegalArgumentException("Length of Schema does not match the number of arguments.");
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) {
                throw new IllegalArgumentException("Arguments must not be null!");
            }
            if (this.arguments[i] instanceof Variable) continue;
            this.validateConstant(i);
        }
    }

    private void validateConstant(int argumentIndex) {
        ConstantType declaredType = this.predicate.getArgumentType(argumentIndex);
        if (this.predicate.getArgumentType(argumentIndex).isInstance((Constant)this.arguments[argumentIndex])) {
            return;
        }
        if (this.arguments[argumentIndex] instanceof DoubleAttribute) {
            this.arguments[argumentIndex] = this.safeDoubleConversion(declaredType, (DoubleAttribute)this.arguments[argumentIndex]);
        } else if (this.arguments[argumentIndex] instanceof IntegerAttribute) {
            this.arguments[argumentIndex] = this.safeIntConversion(declaredType, (IntegerAttribute)this.arguments[argumentIndex]);
        } else if (this.arguments[argumentIndex] instanceof LongAttribute) {
            this.arguments[argumentIndex] = this.safeLongConversion(declaredType, (LongAttribute)this.arguments[argumentIndex]);
        } else if (this.arguments[argumentIndex] instanceof StringAttribute) {
            this.arguments[argumentIndex] = this.safeStringConversion(declaredType, (StringAttribute)this.arguments[argumentIndex]);
        } else {
            if (this.arguments[argumentIndex] instanceof UniqueIntID) {
                throw new IllegalArgumentException(String.format("Expected type %s at position %d but was given: %s (%s) for predicate %s -- %s", new Object[]{this.predicate.getArgumentType(argumentIndex), argumentIndex, this.arguments[argumentIndex], this.arguments[argumentIndex].getClass().getName(), this.predicate, "Unique identifiers cannot be converted to any other type."}));
            }
            if (this.arguments[argumentIndex] instanceof UniqueStringID) {
                throw new IllegalArgumentException(String.format("Expected type %s at position %d but was given: %s (%s) for predicate %s -- %s", new Object[]{this.predicate.getArgumentType(argumentIndex), argumentIndex, this.arguments[argumentIndex], this.arguments[argumentIndex].getClass().getName(), this.predicate, "Unique identifiers cannot be converted to any other type."}));
            }
        }
        if (!this.predicate.getArgumentType(argumentIndex).isInstance((Constant)this.arguments[argumentIndex])) {
            throw new IllegalArgumentException(String.format("Expected type %s at position %d but was given: %s (%s) for predicate %s", new Object[]{this.predicate.getArgumentType(argumentIndex), argumentIndex, this.arguments[argumentIndex], this.arguments[argumentIndex].getClass().getName(), this.predicate}));
        }
    }

    private Term safeDoubleConversion(ConstantType declaredType, DoubleAttribute attribute) {
        Double arg = attribute.getValue();
        if (declaredType == ConstantType.String) {
            return new StringAttribute(arg.toString());
        }
        if (declaredType == ConstantType.UniqueStringID) {
            return new UniqueStringID(arg.toString());
        }
        return attribute;
    }

    private Term safeIntConversion(ConstantType declaredType, IntegerAttribute attribute) {
        Integer arg = attribute.getValue();
        if (declaredType == ConstantType.Double) {
            return new DoubleAttribute(arg.doubleValue());
        }
        if (declaredType == ConstantType.Long) {
            return new LongAttribute(arg.longValue());
        }
        if (declaredType == ConstantType.String) {
            return new StringAttribute(arg.toString());
        }
        if (declaredType == ConstantType.UniqueIntID) {
            return new UniqueIntID(arg);
        }
        if (declaredType == ConstantType.UniqueStringID) {
            return new UniqueStringID(arg.toString());
        }
        if (declaredType == ConstantType.DeferredFunctionalUniqueID) {
            return new UniqueIntID(arg);
        }
        return attribute;
    }

    private Term safeLongConversion(ConstantType declaredType, LongAttribute attribute) {
        Long arg = attribute.getValue();
        if (declaredType == ConstantType.Double) {
            return new DoubleAttribute(arg.doubleValue());
        }
        if (declaredType == ConstantType.Integer) {
            return new IntegerAttribute(arg.intValue());
        }
        if (declaredType == ConstantType.String) {
            return new StringAttribute(arg.toString());
        }
        if (declaredType == ConstantType.UniqueIntID) {
            return new UniqueIntID(arg.intValue());
        }
        if (declaredType == ConstantType.UniqueStringID) {
            return new UniqueStringID(arg.toString());
        }
        return attribute;
    }

    private Term safeStringConversion(ConstantType declaredType, StringAttribute attribute) {
        String arg = attribute.getValue();
        if (declaredType == ConstantType.Double) {
            return new DoubleAttribute(Double.valueOf(arg));
        }
        if (declaredType == ConstantType.Integer) {
            return new IntegerAttribute(Integer.valueOf(arg));
        }
        if (declaredType == ConstantType.Long) {
            return new LongAttribute(Long.valueOf(arg));
        }
        if (declaredType == ConstantType.UniqueIntID) {
            return new UniqueIntID(Integer.parseInt(arg));
        }
        if (declaredType == ConstantType.UniqueStringID) {
            return new UniqueStringID(arg);
        }
        if (declaredType == ConstantType.DeferredFunctionalUniqueID) {
            return new UniqueStringID(arg);
        }
        return attribute;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        if (this.predicate instanceof GroundingOnlyPredicate) {
            s2.append("(");
            if (this.predicate.equals(GroundingOnlyPredicate.NotEqual)) {
                s2.append(this.arguments[0]);
                s2.append(" != ");
                s2.append(this.arguments[1]);
            } else if (this.predicate.equals(GroundingOnlyPredicate.Equal)) {
                s2.append(this.arguments[0]);
                s2.append(" == ");
                s2.append(this.arguments[1]);
            } else if (this.predicate.equals(GroundingOnlyPredicate.NonSymmetric)) {
                s2.append(this.arguments[0]);
                s2.append(" % ");
                s2.append(this.arguments[1]);
            } else {
                throw new UnsupportedOperationException("Unrecognized GroundingOnlyPredicate: " + this.predicate);
            }
            s2.append(")");
        } else {
            s2.append(this.predicate.getName()).append("(");
            String connector = "";
            for (Term arg : this.arguments) {
                s2.append(connector).append(arg);
                connector = ", ";
            }
            s2.append(")");
        }
        return s2.toString();
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object oth) {
        if (oth == this) {
            return true;
        }
        if (oth == null || !(oth instanceof Atom)) {
            return false;
        }
        Atom other = (Atom)oth;
        return this.hashCode() == other.hashCode() && this.predicate.equals(other.predicate) && Arrays.deepEquals(this.arguments, other.arguments);
    }

    @Override
    public Formula flatten() {
        return this;
    }
}

