/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.formula.Disjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.formula.Negation;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.logical.AbstractLogicalRule;
import org.linqs.psl.reasoner.function.GeneralFunction;
import org.linqs.psl.util.HashCode;

public abstract class AbstractGroundLogicalRule
implements GroundRule {
    protected final AbstractLogicalRule rule;
    protected final List<GroundAtom> posLiterals;
    protected final List<GroundAtom> negLiterals;
    protected final GeneralFunction dissatisfaction;
    private final int hashcode;

    protected AbstractGroundLogicalRule(AbstractLogicalRule rule, List<GroundAtom> posLiterals, List<GroundAtom> negLiterals) {
        int i;
        this.rule = rule;
        this.posLiterals = Collections.unmodifiableList(new ArrayList<GroundAtom>(posLiterals));
        this.negLiterals = Collections.unmodifiableList(new ArrayList<GroundAtom>(negLiterals));
        this.dissatisfaction = this.getFunction(true);
        int hash = HashCode.build(rule);
        for (i = 0; i < this.posLiterals.size(); ++i) {
            hash = HashCode.build(hash, this.posLiterals.get(i));
        }
        for (i = 0; i < this.negLiterals.size(); ++i) {
            hash = HashCode.build(hash, this.negLiterals.get(i));
        }
        this.hashcode = hash;
    }

    protected GeneralFunction getFunction(boolean mergeConstants) {
        int i;
        boolean nonNegative = this.posLiterals.size() + this.negLiterals.size() > 1;
        GeneralFunction function = new GeneralFunction(nonNegative, false, this.posLiterals.size() + this.negLiterals.size(), mergeConstants);
        for (i = 0; i < this.posLiterals.size(); ++i) {
            function.add(1.0f, this.posLiterals.get(i));
        }
        for (i = 0; i < this.negLiterals.size(); ++i) {
            function.add(-1.0f, this.negLiterals.get(i));
        }
        function.add(1.0f - (float)this.posLiterals.size());
        return function;
    }

    @Override
    public Set<GroundAtom> getAtoms() {
        HashSet<GroundAtom> atoms = new HashSet<GroundAtom>();
        for (GroundAtom atom : this.posLiterals) {
            atoms.add(atom);
        }
        for (GroundAtom atom : this.negLiterals) {
            atoms.add(atom);
        }
        return atoms;
    }

    public List<GroundAtom> getPositiveAtoms() {
        return this.posLiterals;
    }

    public List<GroundAtom> getNegativeAtoms() {
        return this.negLiterals;
    }

    public int size() {
        return this.posLiterals.size() + this.negLiterals.size();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof AbstractGroundLogicalRule) || this.hashCode() != other.hashCode()) {
            return false;
        }
        AbstractGroundLogicalRule otherRule = (AbstractGroundLogicalRule)other;
        if (!this.rule.equals(otherRule.getRule())) {
            return false;
        }
        return this.posLiterals.equals(otherRule.posLiterals) && this.negLiterals.equals(otherRule.negLiterals);
    }

    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public String baseToString() {
        Formula[] literals = new Formula[this.posLiterals.size() + this.negLiterals.size()];
        for (int i = 0; i < this.posLiterals.size(); ++i) {
            literals[i] = new Negation(this.posLiterals.get(i));
        }
        for (int j = 0; j < this.negLiterals.size(); ++j) {
            literals[i++] = this.negLiterals.get(j);
        }
        return literals.length > 1 ? new Disjunction(literals).toString() : literals[0].toString();
    }

    public String toString() {
        return this.baseToString();
    }
}

