/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.term;

import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.DoubleAttribute;
import org.linqs.psl.model.term.IntegerAttribute;
import org.linqs.psl.model.term.LongAttribute;
import org.linqs.psl.model.term.StringAttribute;
import org.linqs.psl.model.term.UniqueIntID;
import org.linqs.psl.model.term.UniqueStringID;

public enum ConstantType {
    String{

        @Override
        public String getName() {
            return "String";
        }

        @Override
        public boolean isInstance(Constant term) {
            return term instanceof StringAttribute;
        }
    }
    ,
    Integer{

        @Override
        public String getName() {
            return "Integer";
        }

        @Override
        public boolean isInstance(Constant term) {
            return term instanceof IntegerAttribute;
        }
    }
    ,
    Double{

        @Override
        public String getName() {
            return "Double";
        }

        @Override
        public boolean isInstance(Constant term) {
            return term instanceof DoubleAttribute;
        }
    }
    ,
    Long{

        @Override
        public String getName() {
            return "Long";
        }

        @Override
        public boolean isInstance(Constant term) {
            return term instanceof LongAttribute;
        }
    }
    ,
    UniqueIntID{

        @Override
        public String getName() {
            return "UniqueIntID";
        }

        @Override
        public boolean isInstance(Constant term) {
            return term instanceof UniqueIntID;
        }
    }
    ,
    UniqueStringID{

        @Override
        public String getName() {
            return "UniqueStringID";
        }

        @Override
        public boolean isInstance(Constant term) {
            return term instanceof UniqueStringID;
        }
    }
    ,
    DeferredFunctionalUniqueID{

        @Override
        public String getName() {
            return "DeferredFunctionalUniqueID";
        }

        @Override
        public boolean isInstance(Constant term) {
            return term instanceof UniqueIntID || term instanceof UniqueStringID;
        }
    };


    public abstract String getName();

    public abstract boolean isInstance(Constant var1);

    public static ConstantType getType(Constant term) {
        for (ConstantType type : ConstantType.values()) {
            if (!type.isInstance(term)) continue;
            return type;
        }
        throw new IllegalArgumentException("Term is of unknown type : " + term);
    }

    public static Constant getConstant(String value, ConstantType type) {
        switch (type) {
            case Double: {
                return new DoubleAttribute(java.lang.Double.parseDouble(value));
            }
            case Integer: {
                return new IntegerAttribute(java.lang.Integer.parseInt(value));
            }
            case String: {
                return new StringAttribute(value);
            }
            case Long: {
                return new LongAttribute(java.lang.Long.parseLong(value));
            }
            case UniqueIntID: {
                return new UniqueIntID(java.lang.Integer.parseInt(value));
            }
            case UniqueStringID: {
                return new UniqueStringID(value);
            }
        }
        throw new IllegalArgumentException("Unknown argument type: " + (Object)((Object)type));
    }
}

