/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.sgd.term;

import java.util.List;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.reasoner.sgd.term.SGDObjectiveTerm;
import org.linqs.psl.reasoner.sgd.term.SGDOnlineGroundingIterator;
import org.linqs.psl.reasoner.sgd.term.SGDStreamingCacheIterator;
import org.linqs.psl.reasoner.sgd.term.SGDTermGenerator;
import org.linqs.psl.reasoner.term.online.OnlineTermStore;
import org.linqs.psl.reasoner.term.streaming.StreamingIterator;

public class SGDOnlineTermStore
extends OnlineTermStore<SGDObjectiveTerm> {
    public SGDOnlineTermStore(List<Rule> rules, AtomManager atomManager, SGDTermGenerator termGenerator) {
        super(rules, atomManager, termGenerator);
    }

    @Override
    public StreamingIterator<SGDObjectiveTerm> getGroundingIterator(List<Rule> rules) {
        return new SGDOnlineGroundingIterator(this, rules, this.atomManager, this.termGenerator, this.termCache, this.termPool, this.termBuffer, this.volatileBuffer, this.pageSize, this.numPages);
    }

    @Override
    public StreamingIterator<SGDObjectiveTerm> getGroundingIterator() {
        return this.getGroundingIterator(this.rules);
    }

    @Override
    public StreamingIterator<SGDObjectiveTerm> getCacheIterator() {
        return new SGDStreamingCacheIterator(this, false, this.termCache, this.termPool, this.termBuffer, this.volatileBuffer, this.shufflePage, this.shuffleMap, this.randomizePageAccess, this.numPages);
    }

    @Override
    public StreamingIterator<SGDObjectiveTerm> getNoWriteIterator() {
        return new SGDStreamingCacheIterator(this, true, this.termCache, this.termPool, this.termBuffer, this.volatileBuffer, this.shufflePage, this.shuffleMap, this.randomizePageAccess, this.numPages);
    }

    @Override
    public boolean rejectCacheTerm(SGDObjectiveTerm term) {
        boolean allObservedAtoms = true;
        int[] variableIndexes = term.getVariableIndexes();
        for (int i = 0; i < term.size(); ++i) {
            if (this.variableAtoms[variableIndexes[i]] == null) {
                return true;
            }
            if (!(this.variableAtoms[variableIndexes[i]] instanceof RandomVariableAtom)) continue;
            allObservedAtoms = false;
        }
        return allObservedAtoms;
    }
}

