/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.MemoryVariableTermStore;
import org.linqs.psl.reasoner.term.ReasonerLocalVariable;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.TermStore;

public abstract class MemoryConsensusTermStore<T extends ReasonerTerm, V extends ReasonerLocalVariable>
implements TermStore<T, V> {
    protected MemoryVariableTermStore<T, RandomVariableAtom> store = new MemoryVariableTermStore<T, RandomVariableAtom>(){

        @Override
        protected RandomVariableAtom convertAtomToVariable(RandomVariableAtom atom) {
            return atom;
        }
    };
    protected List<List<V>> localVariables = new ArrayList<List<V>>();
    protected long numLocalVariables = 0L;

    @Override
    public synchronized V createLocalVariable(GroundAtom groundAtom) {
        if (!(groundAtom instanceof RandomVariableAtom)) {
            throw new IllegalArgumentException("MemoryConsensusTermStores do not keep track of observed atoms (" + groundAtom + ").");
        }
        RandomVariableAtom atom = (RandomVariableAtom)groundAtom;
        ++this.numLocalVariables;
        this.store.createLocalVariable(atom);
        int consensusId = this.store.getVariableIndex(atom);
        assert (consensusId <= this.localVariables.size());
        if (consensusId == this.localVariables.size()) {
            this.localVariables.add(new ArrayList());
        }
        V localVariable = this.createLocalVariableInternal(atom, consensusId, atom.getValue());
        this.localVariables.get(consensusId).add(localVariable);
        return localVariable;
    }

    public long getNumLocalVariables() {
        return this.numLocalVariables;
    }

    public int getNumConsensusVariables() {
        return this.store.getNumRandomVariables();
    }

    public List<V> getLocalVariables(int consensusId) {
        return this.localVariables.get(consensusId);
    }

    public float[] getConsensusValues() {
        return this.store.getVariableValues();
    }

    @Override
    public double syncAtoms() {
        return this.store.syncAtoms();
    }

    @Override
    public void add(GroundRule rule, T term, Hyperplane hyperplane) {
        this.store.add(rule, term, hyperplane);
    }

    @Override
    public void clear() {
        if (this.store != null) {
            this.store.clear();
        }
        if (this.localVariables != null) {
            this.localVariables.clear();
        }
        this.numLocalVariables = 0L;
    }

    @Override
    public void reset() {
        this.resetLocalVariables();
        this.store.reset();
    }

    @Override
    public void close() {
        this.clear();
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        this.localVariables = null;
    }

    @Override
    public void initForOptimization() {
        this.store.initForOptimization();
        if (this.store.getVariablesExternallyUpdatedFlag()) {
            this.variablesExternallyUpdated();
            this.store.resetVariablesExternallyUpdatedFlag();
        }
    }

    @Override
    public void iterationComplete() {
        this.store.iterationComplete();
        if (this.store.getVariablesExternallyUpdatedFlag()) {
            this.variablesExternallyUpdated();
            this.store.resetVariablesExternallyUpdatedFlag();
        }
    }

    public RandomVariableAtom getAtom(int index) {
        return this.store.getAtom(index);
    }

    @Override
    public T get(long index) {
        return this.store.get(index);
    }

    @Override
    public long size() {
        return this.store.size();
    }

    @Override
    public void ensureCapacity(long capacity) {
        this.store.ensureCapacity(capacity);
    }

    @Override
    public void ensureVariableCapacity(int capacity) {
        this.store.ensureVariableCapacity(capacity);
        ((ArrayList)this.localVariables).ensureCapacity(capacity);
    }

    @Override
    public void variablesExternallyUpdated() {
        this.store.variablesExternallyUpdated();
    }

    @Override
    public Iterator<T> iterator() {
        return this.store.iterator();
    }

    @Override
    public Iterator<T> noWriteIterator() {
        return this.iterator();
    }

    protected abstract V createLocalVariableInternal(RandomVariableAtom var1, int var2, float var3);

    protected abstract void resetLocalVariables();
}

