/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.online;

import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.atom.OnlineAtomManager;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.streaming.StreamingIterator;
import org.linqs.psl.reasoner.term.streaming.StreamingTermStore;
import org.linqs.psl.util.IteratorUtils;
import org.linqs.psl.util.Logger;

public abstract class OnlineTermStore<T extends ReasonerTerm>
extends StreamingTermStore<T> {
    private static final Logger log = Logger.getLogger(OnlineTermStore.class);
    protected List<Integer> activeTermPages = new ArrayList<Integer>();
    protected List<Integer> activeVolatilePages = new ArrayList<Integer>();
    protected Integer nextTermPageIndex;
    protected Integer nextVolatilePageIndex;
    protected Map<Rule, List<Integer>> rulePageMapping = new HashMap<Rule, List<Integer>>();
    protected Map<Rule, Boolean> activatedRules = new HashMap<Rule, Boolean>();

    public OnlineTermStore(List<Rule> rules, AtomManager atomManager, HyperplaneTermGenerator<T, GroundAtom> termGenerator) {
        super(rules, atomManager, termGenerator);
        for (Rule rule : rules) {
            this.activatedRules.put(rule, true);
            this.rulePageMapping.put(rule, new ArrayList());
        }
        this.nextTermPageIndex = 0;
        this.nextVolatilePageIndex = 0;
    }

    @Override
    public boolean isLoaded() {
        return !this.initialRound && ((OnlineAtomManager)this.atomManager).hasNewAtoms() == false;
    }

    @Override
    protected int estimateVariableCapacity() {
        return this.atomManager.getCachedRVACount() + this.atomManager.getCachedObsCount();
    }

    public synchronized void deleteLocalVariable(GroundAtom atom) {
        int index = this.getVariableIndex(atom);
        if (index == -1) {
            return;
        }
        this.variables.remove(atom);
        this.variableValues[index] = -1.0f;
        this.variableAtoms[index] = null;
        if (atom instanceof RandomVariableAtom) {
            --this.numRandomVariableAtoms;
        } else {
            --this.numObservedAtoms;
        }
    }

    public synchronized void updateLocalVariable(ObservedAtom atom, float newValue) {
        if (!this.variables.containsKey(atom)) {
            return;
        }
        if (this.variableAtoms[this.getVariableIndex(atom)] instanceof RandomVariableAtom) {
            --this.numRandomVariableAtoms;
            ++this.numObservedAtoms;
        }
        this.variableAtoms[this.getVariableIndex((GroundAtom)atom)] = atom;
        this.variableValues[this.getVariableIndex((GroundAtom)atom)] = newValue;
    }

    public synchronized void activateRule(Rule rule) {
        if (!this.rules.contains(rule)) {
            return;
        }
        List<Integer> rulePages = this.rulePageMapping.get(rule);
        int activePageIndex = 0;
        for (Integer pageIndex : rulePages) {
            activePageIndex = this.activeTermPages.indexOf(pageIndex);
            if (activePageIndex != -1) continue;
            this.activeTermPages.add(pageIndex);
            ++this.numPages;
        }
        this.activatedRules.put(rule, true);
    }

    public synchronized void addRule(Rule rule) {
        if (this.rules.contains(rule)) {
            return;
        }
        this.rules.add(rule);
        this.rulePageMapping.put(rule, new ArrayList());
        this.activatedRules.put(rule, true);
        this.initialRound = true;
        StreamingIterator<T> groundingIterator = this.getGroundingIterator(Arrays.asList(rule));
        while (groundingIterator.hasNext()) {
            groundingIterator.next();
        }
    }

    public synchronized void deactivateRule(Rule rule) {
        if (!this.rules.contains(rule)) {
            return;
        }
        this.removeActiveTermPages(rule);
        this.activatedRules.put(rule, false);
    }

    public synchronized void deleteRule(Rule rule) {
        if (!this.rules.contains(rule)) {
            return;
        }
        this.removeActiveTermPages(rule);
        this.rules.remove(rule);
        this.activatedRules.remove(rule);
        this.rulePageMapping.remove(rule);
    }

    private void removeActiveTermPages(Rule rule) {
        List<Integer> rulePages = this.rulePageMapping.get(rule);
        int activePageIndex = 0;
        for (Integer pageIndex : rulePages) {
            activePageIndex = this.activeTermPages.indexOf(pageIndex);
            if (activePageIndex == -1) continue;
            this.activeTermPages.remove(activePageIndex);
            --this.numPages;
        }
    }

    public abstract StreamingIterator<T> getGroundingIterator(List<Rule> var1);

    @Override
    public double syncAtoms() {
        double movement = 0.0;
        for (int i = 0; i < this.totalVariableCount; ++i) {
            if (this.variableAtoms[i] == null) continue;
            if (this.variableAtoms[i] instanceof RandomVariableAtom) {
                movement += Math.pow(this.variableAtoms[i].getValue() - this.variableValues[i], 2.0);
                ((RandomVariableAtom)this.variableAtoms[i]).setValue(this.variableValues[i]);
                continue;
            }
            ((ObservedAtom)this.variableAtoms[i])._assumeValue(this.variableValues[i]);
        }
        return Math.sqrt(movement);
    }

    @Override
    public String getTermPagePath(int index) {
        this.buildActivePagePath(index);
        return (String)this.termPagePaths.get(this.activeTermPages.get(index));
    }

    @Override
    public String getVolatilePagePath(int index) {
        for (int i = this.activeVolatilePages.size(); i <= index; ++i) {
            this.volatilePagePaths.add(Paths.get(this.pageDir, String.format("%08d_volatile.page", this.nextVolatilePageIndex)).toString());
            this.activeVolatilePages.add(this.nextVolatilePageIndex);
            Integer n = this.nextVolatilePageIndex;
            Integer n2 = this.nextVolatilePageIndex = Integer.valueOf(this.nextVolatilePageIndex + 1);
        }
        return (String)this.volatilePagePaths.get(this.activeVolatilePages.get(index));
    }

    public void addRuleMapping(Rule rule, int pageIndex) {
        this.buildActivePagePath(pageIndex);
        this.rulePageMapping.get(rule).add(this.activeTermPages.get(pageIndex));
    }

    private void buildActivePagePath(int index) {
        for (int i = this.activeTermPages.size(); i <= index; ++i) {
            this.termPagePaths.add(Paths.get(this.pageDir, String.format("%08d_term.page", this.nextTermPageIndex)).toString());
            this.activeTermPages.add(this.nextTermPageIndex);
            Integer n = this.nextTermPageIndex;
            Integer n2 = this.nextTermPageIndex = Integer.valueOf(this.nextTermPageIndex + 1);
        }
    }

    @Override
    public void groundingIterationComplete(long termCount, int numPages, ByteBuffer termBuffer, ByteBuffer volatileBuffer) {
        super.groundingIterationComplete(termCount, numPages, termBuffer, volatileBuffer);
        for (Rule rule : this.rules) {
            if (this.activatedRules.get(rule).booleanValue()) continue;
            List<Integer> rulePages = this.rulePageMapping.get(rule);
            for (Integer pageIndex : rulePages) {
                int activePageIndex = this.activeTermPages.indexOf(pageIndex);
                if (activePageIndex == -1) continue;
                this.activeTermPages.remove(activePageIndex);
                --this.numPages;
            }
        }
    }

    private void joinIterationComplete() {
        this.activeIterator = null;
    }

    @Override
    protected StreamingIterator<T> streamingIterator() {
        this.activeIterator = super.streamingIterator();
        if (!this.initialRound && ((OnlineAtomManager)this.atomManager).hasNewAtoms().booleanValue()) {
            this.activeIterator = new StreamingJoinIterator(IteratorUtils.join(this.activeIterator, this.getGroundingIterator()));
        }
        return this.activeIterator;
    }

    private class StreamingJoinIterator<E extends ReasonerTerm>
    implements StreamingIterator<E> {
        private Iterator<E> iterator;

        public StreamingJoinIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.iterator.hasNext();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        @Override
        public E next() {
            return (E)((ReasonerTerm)this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void close() {
            OnlineTermStore.this.joinIterationComplete();
        }
    }
}

