/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.common.util.resource;

import com.healthmarketscience.common.util.URLProtocolHandlerUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Handler
extends URLStreamHandler {
    private static final Log LOG = LogFactory.getLog(Handler.class);
    private static final String PROTOCOL = "resource";

    public static void init() {
    }

    protected void parseURL(URL u, String spec, int start, int limit) {
        super.setURL(u, PROTOCOL, null, -1, null, null, spec.substring(start, limit), null, null);
    }

    protected URLConnection openConnection(URL u) throws IOException {
        URL res = this.convertToSystemURL(u);
        if (res == null) {
            throw new FileNotFoundException(u + " not found");
        }
        return res.openConnection();
    }

    public URL convertToSystemURL(URL u) {
        URL res;
        String path = u.getFile();
        while (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL uRL = res = loader != null ? loader.getResource(path) : null;
        if (res == null) {
            res = u.getClass().getResource(path);
        }
        if (res == null) {
            res = ClassLoader.getSystemResource(path);
        }
        while (res == null && loader != null) {
            if ((loader = loader.getParent()) == null) continue;
            res = loader.getResource(path);
        }
        return res;
    }

    static {
        try {
            URLProtocolHandlerUtil.registerProtocolHandler(PROTOCOL, new Handler());
        }
        catch (Error e) {
            LOG.warn("Can't register protocol handler", e);
            throw e;
        }
        catch (RuntimeException e) {
            LOG.warn("Can't register protocol handler", e);
            throw e;
        }
    }
}

