/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.search;

import org.linqs.psl.config.Options;
import org.linqs.psl.util.MathUtils;
import org.linqs.psl.util.RandUtils;

public class WeightSampler {
    private boolean searchDirichlet;
    private double[] dirichletAlphas;
    private int numWeights;

    public WeightSampler(int numWeights) {
        this.numWeights = numWeights;
        this.searchDirichlet = Options.WLA_SEARCH_DIRICHLET.getBoolean();
        double dirichletAlpha = Options.WLA_SEARCH_DIRICHLET_ALPHA.getDouble();
        this.dirichletAlphas = new double[this.numWeights];
        for (int i = 0; i < this.numWeights; ++i) {
            this.dirichletAlphas[i] = dirichletAlpha;
        }
    }

    public void getRandomWeights(float[] weights) {
        if (this.searchDirichlet) {
            this.getDirichletRandomWeights(weights);
        } else {
            this.getHypercubeRandomWeights(weights);
        }
    }

    private void getDirichletRandomWeights(float[] weights) {
        double[] dirichletSample = RandUtils.sampleDirichlet(this.dirichletAlphas);
        MathUtils.toUnit(dirichletSample);
        for (int i = 0; i < this.numWeights; ++i) {
            weights[i] = (float)dirichletSample[i];
        }
    }

    private void getHypercubeRandomWeights(float[] weights) {
        for (int i = 0; i < this.numWeights; ++i) {
            weights[i] = RandUtils.nextFloat();
        }
    }
}

