/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms.driver;

import java.util.ArrayList;
import org.linqs.psl.database.rdbms.driver.DatabaseDriver;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.util.FileUtils;
import org.linqs.psl.util.ListUtils;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.StringUtils;

public class H2DatabaseDriver
extends DatabaseDriver {
    private static final Logger log = Logger.getLogger(H2DatabaseDriver.class);
    public static final int LOCK_TIMEOUT_MS = 300000;

    public H2DatabaseDriver(Type dbType, String path, boolean clear) {
        super("org.h2.Driver", H2DatabaseDriver.buildConnectionString(dbType, path), H2DatabaseDriver.checkClearDatabase(dbType, path, clear));
        log.debug("Connected to H2 database: " + path);
    }

    private static String buildConnectionString(Type dbType, String path) {
        String connectionString = "jdbc:h2";
        switch (dbType) {
            case Disk: {
                connectionString = connectionString + ":" + path;
                break;
            }
            case Memory: {
                connectionString = connectionString + ":mem:" + path;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown database type: " + (Object)((Object)dbType));
            }
        }
        connectionString = connectionString + ";LOCK_TIMEOUT=300000";
        return connectionString;
    }

    private static boolean checkClearDatabase(Type dbType, String path, boolean clear) {
        if (!clear) {
            return false;
        }
        if (dbType == Type.Memory) {
            return true;
        }
        FileUtils.delete(path + ".mv.db");
        FileUtils.delete(path + ".trace.db");
        return true;
    }

    @Override
    protected void clearDatabase() {
        this.executeUpdate("DROP ALL OBJECTS");
    }

    @Override
    public String getTypeName(ConstantType type) {
        switch (type) {
            case Double: {
                return "DOUBLE";
            }
            case Integer: {
                return "INT";
            }
            case String: {
                return "VARCHAR";
            }
            case Long: {
                return "BIGINT";
            }
            case UniqueIntID: {
                return "INT";
            }
            case UniqueStringID: {
                return "VARCHAR(255)";
            }
        }
        throw new IllegalStateException("Unknown ConstantType: " + (Object)((Object)type));
    }

    @Override
    public String getSurrogateKeyColumnDefinition(String columnName) {
        return columnName + " BIGINT IDENTITY PRIMARY KEY";
    }

    @Override
    public String getDoubleTypeName() {
        return "DOUBLE";
    }

    @Override
    public String getUpsert(String tableName, String[] columns, String[] keyColumns) {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("MERGE INTO " + tableName + "");
        sql.add("    (" + StringUtils.join(", ", (Object[])columns) + ")");
        sql.add("KEY");
        sql.add("    (" + StringUtils.join(", ", (Object[])keyColumns) + ")");
        sql.add("VALUES");
        sql.add("    (" + StringUtils.repeat("?", ", ", columns.length) + ")");
        return ListUtils.join(System.lineSeparator(), sql);
    }

    @Override
    public void updateDBStats() {
        this.executeUpdate("ANALYZE");
    }

    public static enum Type {
        Disk,
        Memory;

    }
}

