/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.evaluation.statistics;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.application.learning.weight.TrainingMap;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.atom.UnmanagedAtom;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.util.IteratorUtils;

public abstract class Evaluator {
    protected boolean includeObserved = Options.EVAL_INCLUDE_OBS.getBoolean();
    protected boolean closeTruth = Options.EVAL_CLOSE_TRUTH.getBoolean();

    protected Evaluator() {
    }

    public boolean getIncludeObserved() {
        return this.includeObserved;
    }

    public void setIncludeObserved(boolean includeObserved) {
        this.includeObserved = includeObserved;
    }

    public boolean getCloseTruth() {
        return this.closeTruth;
    }

    public void setCloseTruth(boolean closeTruth) {
        this.closeTruth = closeTruth;
    }

    public abstract void compute(TrainingMap var1);

    public abstract void compute(TrainingMap var1, StandardPredicate var2);

    public abstract double getRepMetric();

    public abstract boolean isHigherRepBetter();

    public double getNormalizedRepMetric() {
        double value = this.getRepMetric();
        if (!this.isHigherRepBetter()) {
            value = -value;
        }
        return value;
    }

    public double getNormalizedMaxRepMetric() {
        double value = this.getBestRepScore();
        if (!this.isHigherRepBetter()) {
            value = -value;
        }
        return value;
    }

    public abstract double getBestRepScore();

    public abstract String getAllStats();

    public void compute(Database rvDB, Database truthDB, StandardPredicate predicate, boolean rvDBCached) {
        PersistedAtomManager atomManager = new PersistedAtomManager(rvDB, rvDBCached);
        TrainingMap map = new TrainingMap(atomManager, truthDB);
        this.compute(map, predicate);
    }

    public void compute(Database rvDB, Database truthDB, StandardPredicate predicate) {
        this.compute(rvDB, truthDB, predicate, false);
    }

    public Iterable<Map.Entry<GroundAtom, GroundAtom>> getMap(TrainingMap trainingMap) {
        Iterable<Map.Entry<GroundAtom, GroundAtom>> map = trainingMap.getLabelMap().entrySet();
        if (this.includeObserved) {
            Set<Map.Entry<ObservedAtom, ObservedAtom>> observedMap = trainingMap.getObservedMap().entrySet();
            map = IteratorUtils.join(map, observedMap);
        }
        if (this.closeTruth) {
            List<RandomVariableAtom> latentAtoms = trainingMap.getLatentVariables();
            Iterable<Map.Entry<GroundAtom, GroundAtom>> latentMap = IteratorUtils.map(latentAtoms, new IteratorUtils.MapFunction<GroundAtom, Map.Entry<GroundAtom, GroundAtom>>(){

                @Override
                public Map.Entry<GroundAtom, GroundAtom> map(GroundAtom atom) {
                    UnmanagedAtom truthAtom = new UnmanagedAtom(atom.getPredicate(), atom.getArguments(), 0.0f);
                    return new AbstractMap.SimpleEntry<GroundAtom, GroundAtom>(atom, truthAtom);
                }
            });
            map = IteratorUtils.join(map, latentMap);
        }
        return map;
    }

    public Iterable<GroundAtom> getTargets(TrainingMap trainingMap) {
        if (this.includeObserved) {
            return trainingMap.getAllTargets();
        }
        Iterable<GroundAtom> targets = trainingMap.getAllPredictions();
        return targets;
    }
}

