/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.grounding.collective;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.model.term.VariableTypeMap;
import org.linqs.psl.util.MathUtils;

public class CandidateQuery
implements Comparable<CandidateQuery> {
    private final Rule baseRule;
    private final Formula formula;
    private final double score;
    private final Map<Rule, Map<Variable, Variable>> coveredVariableMappings;
    private final Set<Rule> uncoveredRules;

    public CandidateQuery(Rule baseRule, Formula formula, double score) {
        this.baseRule = baseRule;
        this.formula = formula;
        this.score = score;
        this.coveredVariableMappings = new HashMap<Rule, Map<Variable, Variable>>();
        Set<Variable> variables = formula.collectVariables(new VariableTypeMap()).getVariables();
        HashMap<Variable, Variable> selfMapping = new HashMap<Variable, Variable>();
        for (Variable variable : variables) {
            selfMapping.put(variable, variable);
        }
        this.coveredVariableMappings.put(baseRule, selfMapping);
        this.uncoveredRules = new HashSet<Rule>();
    }

    public Formula getFormula() {
        return this.formula;
    }

    public double getScore() {
        return this.score;
    }

    public Rule getBaseRule() {
        return this.baseRule;
    }

    public Set<Rule> getCoveredRules() {
        return this.coveredVariableMappings.keySet();
    }

    public Map<Variable, Variable> getVariableMapping(Rule rule) {
        return this.coveredVariableMappings.get(rule);
    }

    public Map<Variable, Variable> getSelfVariableMapping() {
        return this.coveredVariableMappings.get(this.baseRule);
    }

    public Map<Rule, Map<Variable, Variable>> getCoveredVariableMappings() {
        return this.coveredVariableMappings;
    }

    public int hashCode() {
        return this.formula.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof CandidateQuery)) {
            return false;
        }
        return this.formula.equals(((CandidateQuery)other).formula);
    }

    @Override
    public int compareTo(CandidateQuery other) {
        if (other == null) {
            return -1;
        }
        if (this == other) {
            return 0;
        }
        int value = MathUtils.compare(this.score, other.score);
        if (value != 0) {
            return value;
        }
        return this.formula.toString().compareTo(other.formula.toString());
    }
}

