/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.grounding.collective;

import java.util.Collection;
import java.util.LinkedList;
import java.util.PriorityQueue;
import org.linqs.psl.grounding.collective.CandidateSearchNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchFringe<T extends Collection<CandidateSearchNode>> {
    private static final Logger log = LoggerFactory.getLogger(SearchFringe.class);
    protected double bestPessimisticCost;
    protected T fringe;

    protected SearchFringe(T fringe) {
        this.fringe = fringe;
        this.bestPessimisticCost = Double.MAX_VALUE;
    }

    public int size() {
        return this.fringe.size();
    }

    public void clear() {
        this.fringe.clear();
        this.bestPessimisticCost = Double.MAX_VALUE;
    }

    public void newPessimisticCost(double pessimisticCost) {
        if (pessimisticCost < this.bestPessimisticCost) {
            this.bestPessimisticCost = pessimisticCost;
        }
    }

    public void push(CandidateSearchNode node) {
        if (node == null) {
            return;
        }
        this.pushInternal(node);
    }

    protected abstract boolean pushInternal(CandidateSearchNode var1);

    public abstract CandidateSearchNode pop();

    public static class BoundedDFSSearchFringe
    extends DFSSearchFringe {
        @Override
        protected boolean pushInternal(CandidateSearchNode node) {
            if (node.optimisticCost > this.bestPessimisticCost) {
                return false;
            }
            return super.pushInternal(node);
        }
    }

    public static class BoundedUCSSearchFringe
    extends UCSSearchFringe {
        @Override
        protected boolean pushInternal(CandidateSearchNode node) {
            if (node.optimisticCost > this.bestPessimisticCost) {
                return false;
            }
            return super.pushInternal(node);
        }
    }

    public static class UCSSearchFringe
    extends SearchFringe<PriorityQueue<CandidateSearchNode>> {
        public UCSSearchFringe() {
            super(new PriorityQueue(11));
        }

        @Override
        protected boolean pushInternal(CandidateSearchNode node) {
            ((PriorityQueue)this.fringe).add(node);
            return true;
        }

        @Override
        public CandidateSearchNode pop() {
            return (CandidateSearchNode)((PriorityQueue)this.fringe).poll();
        }
    }

    public static class DFSSearchFringe
    extends SearchFringe<LinkedList<CandidateSearchNode>> {
        public DFSSearchFringe() {
            super(new LinkedList());
        }

        @Override
        protected boolean pushInternal(CandidateSearchNode node) {
            ((LinkedList)this.fringe).addFirst(node);
            return true;
        }

        @Override
        public CandidateSearchNode pop() {
            return (CandidateSearchNode)((LinkedList)this.fringe).removeFirst();
        }
    }

    public static class BFSSearchFringe
    extends SearchFringe<LinkedList<CandidateSearchNode>> {
        public BFSSearchFringe() {
            super(new LinkedList());
        }

        @Override
        protected boolean pushInternal(CandidateSearchNode node) {
            ((LinkedList)this.fringe).addLast(node);
            return true;
        }

        @Override
        public CandidateSearchNode pop() {
            return (CandidateSearchNode)((LinkedList)this.fringe).removeFirst();
        }
    }
}

