/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.java;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.linqs.psl.database.DataStore;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.function.ExternalFunction;
import org.linqs.psl.model.predicate.ExternalFunctionalPredicate;
import org.linqs.psl.model.predicate.FunctionalPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.parser.ModelLoader;
import org.linqs.psl.parser.RulePartial;

public class PSLModel
extends Model {
    private DataStore dataStore;

    public PSLModel(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public StandardPredicate addPredicate(String name, ConstantType ... args) {
        StandardPredicate predicate = StandardPredicate.get(name, args);
        this.dataStore.registerPredicate(predicate);
        return predicate;
    }

    public FunctionalPredicate addFunction(String name, ExternalFunction function) {
        ExternalFunctionalPredicate predicate = ExternalFunctionalPredicate.get(name, function);
        return predicate;
    }

    public Rule addRule(String ruleString) {
        Rule rule = ModelLoader.loadRule(ruleString);
        this.addRule(rule);
        return rule;
    }

    public Rule addWeightedRule(String ruleString, float weight, boolean squared) {
        return this.addRule(ruleString, true, weight, squared);
    }

    public Rule addUnweightedRule(String ruleString) {
        return this.addRule(ruleString);
    }

    public Rule addRule(String ruleString, boolean weighted, float weight, boolean squared) {
        RulePartial rulePartial = ModelLoader.loadRulePartial(ruleString);
        Rule rule = null;
        rule = weighted ? rulePartial.toRule(Float.valueOf(weight), squared) : rulePartial.toRule(null, null);
        this.addRule(rule);
        return rule;
    }

    public List<Rule> addRules(String rules) {
        return this.addRules(new StringReader(rules));
    }

    public List<Rule> addRules(Reader rules) {
        ArrayList<Rule> addedRules = new ArrayList<Rule>();
        Model model = ModelLoader.load(rules);
        for (Rule rule : model.getRules()) {
            this.addRule(rule);
            addedRules.add(rule);
        }
        return addedRules;
    }

    public Predicate getPredicate(String name) {
        return Predicate.get(name);
    }

    public StandardPredicate getStandardPredicate(String name) {
        return StandardPredicate.get(name);
    }

    public FunctionalPredicate getFunctionalPredicate(String name) {
        return ExternalFunctionalPredicate.get(name);
    }
}

