/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.formula;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.term.VariableTypeMap;
import org.linqs.psl.util.HashCode;

public abstract class AbstractBranchFormula<T extends AbstractBranchFormula<T>>
implements Formula {
    protected final Formula[] formulas;
    protected int hashcode;

    public AbstractBranchFormula(Formula ... f) {
        if (f.length < 2) {
            throw new IllegalArgumentException("Must provide at least two formulas!");
        }
        this.formulas = f;
        for (int i = 0; i < f.length; ++i) {
            if (this.formulas[i] != null) continue;
            throw new IllegalArgumentException("Formulas must not be null!");
        }
        this.hashcode = HashCode.build(this.formulas);
    }

    public int length() {
        return this.formulas.length;
    }

    public Formula get(int pos) {
        return this.formulas[pos];
    }

    @Override
    public VariableTypeMap collectVariables(VariableTypeMap varMap) {
        for (int i = 0; i < this.formulas.length; ++i) {
            this.formulas[i].collectVariables(varMap);
        }
        return varMap;
    }

    @Override
    public Set<Atom> getAtoms(Set<Atom> atoms) {
        for (int i = 0; i < this.formulas.length; ++i) {
            this.formulas[i].getAtoms(atoms);
        }
        return atoms;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object oth) {
        if (oth == this) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth) || this.hashCode() != oth.hashCode()) {
            return false;
        }
        AbstractBranchFormula of = (AbstractBranchFormula)oth;
        return Arrays.equals(this.formulas, of.formulas);
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append("( ");
        for (int i = 0; i < this.formulas.length; ++i) {
            if (i > 0) {
                s2.append(" ").append(this.separatorString()).append(" ");
            }
            s2.append(this.formulas[i]);
        }
        s2.append(" )");
        return s2.toString();
    }

    @Override
    public Formula flatten() {
        HashSet<Formula> flatComponents = new HashSet<Formula>();
        for (Formula component : this.formulas) {
            if (this.getClass().isAssignableFrom(component.getClass())) {
                Formula[] newComponents;
                for (Formula newComponent : newComponents = ((AbstractBranchFormula)component.flatten()).formulas) {
                    flatComponents.add(newComponent);
                }
                continue;
            }
            flatComponents.add(component);
        }
        try {
            Formula[] args = flatComponents.toArray(new Formula[0]);
            return (Formula)this.getClass().getConstructor(Formula[].class).newInstance(new Object[]{args});
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("AbstractBranchFormula does not have a constructor that takes an Array of Formula.", ex);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new RuntimeException("AbstractBranchFormula could not be constructed.", ex);
        }
    }

    protected abstract String separatorString();
}

