/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.predicate;

import java.util.Map;
import org.linqs.psl.database.ReadableDatabase;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.predicate.FunctionalPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.UniqueIntID;
import org.linqs.psl.model.term.UniqueStringID;
import org.linqs.psl.model.term.Variable;

public abstract class GroundingOnlyPredicate
extends FunctionalPredicate {
    public static final GroundingOnlyPredicate Equal = new GroundingOnlyPredicate("#Equal", new ConstantType[]{ConstantType.DeferredFunctionalUniqueID, ConstantType.DeferredFunctionalUniqueID}){

        @Override
        public double computeValue(ReadableDatabase db, Constant ... args) {
            GroundingOnlyPredicate.checkArguments(this.getName(), args);
            return this.computeValue(args[0], args[1]);
        }

        @Override
        public double computeValue(Constant a, Constant b) {
            return a.equals(b) ? 1.0 : 0.0;
        }
    };
    public static final GroundingOnlyPredicate NotEqual = new GroundingOnlyPredicate("#NotEqual", new ConstantType[]{ConstantType.DeferredFunctionalUniqueID, ConstantType.DeferredFunctionalUniqueID}){

        @Override
        public double computeValue(ReadableDatabase db, Constant ... args) {
            GroundingOnlyPredicate.checkArguments(this.getName(), args);
            return this.computeValue(args[0], args[1]);
        }

        @Override
        public double computeValue(Constant a, Constant b) {
            return !a.equals(b) ? 1.0 : 0.0;
        }
    };
    public static final GroundingOnlyPredicate NonSymmetric = new GroundingOnlyPredicate("#NonSymmetric", new ConstantType[]{ConstantType.DeferredFunctionalUniqueID, ConstantType.DeferredFunctionalUniqueID}){

        @Override
        public double computeValue(ReadableDatabase db, Constant ... args) {
            GroundingOnlyPredicate.checkArguments(this.getName(), args);
            return this.computeValue(args[0], args[1]);
        }

        @Override
        public double computeValue(Constant a, Constant b) {
            return a.compareTo(b) < 0 ? 1.0 : 0.0;
        }
    };

    private GroundingOnlyPredicate(String name, ConstantType[] types) {
        super(name, types, false);
    }

    public double computeValue(Atom atom, Map<Variable, Integer> variableMap, Constant[] constants) {
        assert (this == atom.getPredicate());
        Term[] arguments = atom.getArguments();
        assert (arguments.length == 2);
        Constant lhs = null;
        Constant rhs = null;
        if (arguments[0] instanceof Constant) {
            lhs = (Constant)arguments[0];
        } else if (arguments[0] instanceof Variable) {
            lhs = constants[variableMap.get((Variable)arguments[0])];
        } else {
            throw new RuntimeException("Expecting Constant or Variable, but found: " + arguments[0].getClass());
        }
        if (arguments[1] instanceof Constant) {
            rhs = (Constant)arguments[1];
        } else if (arguments[1] instanceof Variable) {
            rhs = constants[variableMap.get((Variable)arguments[1])];
        } else {
            throw new RuntimeException("Expecting Constant or Variable, but found: " + arguments[1].getClass());
        }
        return this.computeValue(lhs, rhs);
    }

    public abstract double computeValue(Constant var1, Constant var2);

    private static final void checkArguments(String functionName, Constant[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException(functionName + " expects two arguments, got " + args.length + ".");
        }
        if (!(args[0] instanceof UniqueIntID) && !(args[0] instanceof UniqueStringID) || !(args[1] instanceof UniqueIntID) && !(args[1] instanceof UniqueStringID)) {
            throw new IllegalArgumentException(String.format("%s expects both arguments to be a Unique*ID. Instead, got: (%s, %s).", functionName, args[0].getClass().getName(), args[1].getClass().getName()));
        }
        if (args[0].getClass() != args[1].getClass()) {
            throw new IllegalArgumentException(String.format("%s expects both arguments to be Unique*IDs of the same type. Instead, got: (%s, %s).", functionName, args[0].getClass().getName(), args[1].getClass().getName()));
        }
    }
}

