/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.atom.QueryAtom;
import org.linqs.psl.model.formula.Conjunction;
import org.linqs.psl.model.formula.Disjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.formula.Implication;
import org.linqs.psl.model.formula.Negation;
import org.linqs.psl.model.predicate.GroundingOnlyPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.arithmetic.UnweightedArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.WeightedArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.expression.ArithmeticRuleExpression;
import org.linqs.psl.model.rule.arithmetic.expression.SummationAtom;
import org.linqs.psl.model.rule.arithmetic.expression.SummationAtomOrAtom;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariable;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariableOrTerm;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Add;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Cardinality;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Coefficient;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.ConstantNumber;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Divide;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Max;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Min;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Multiply;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Subtract;
import org.linqs.psl.model.rule.logical.UnweightedLogicalRule;
import org.linqs.psl.model.rule.logical.WeightedLogicalRule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.StringAttribute;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.parser.RulePartial;
import org.linqs.psl.parser.antlr.PSLBaseVisitor;
import org.linqs.psl.parser.antlr.PSLLexer;
import org.linqs.psl.parser.antlr.PSLParser;
import org.linqs.psl.reasoner.function.FunctionComparator;

public class ModelLoader
extends PSLBaseVisitor<Object> {
    public static RulePartial loadRulePartial(String input) {
        PSLParser parser = null;
        try {
            parser = ModelLoader.getParser(input);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to lex rule partial.", ex);
        }
        PSLParser.PslRulePartialContext context = null;
        try {
            context = parser.pslRulePartial();
        }
        catch (ParseCancellationException ex) {
            throw (RuntimeException)ex.getCause();
        }
        ModelLoader visitor = new ModelLoader();
        return visitor.visitPslRulePartial(context);
    }

    public static Rule loadRule(String input) {
        Model model = ModelLoader.load(new StringReader(input));
        int ruleCount = 0;
        Rule targetRule = null;
        for (Rule rule : model.getRules()) {
            if (ruleCount == 0) {
                targetRule = rule;
            }
            ++ruleCount;
        }
        if (ruleCount != 1) {
            throw new IllegalArgumentException(String.format("Expected 1 rule, found %d.", ruleCount));
        }
        return targetRule;
    }

    public static Model load(String input) {
        return ModelLoader.load(new StringReader(input));
    }

    public static Model load(Reader input) {
        PSLParser parser = null;
        try {
            parser = ModelLoader.getParser(input);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to lex rule partial.", ex);
        }
        PSLParser.ProgramContext program = null;
        try {
            program = parser.program();
        }
        catch (ParseCancellationException ex) {
            throw (RuntimeException)ex.getCause();
        }
        ModelLoader visitor = new ModelLoader();
        return visitor.visitProgram(program, parser);
    }

    public static Atom loadAtom(String input) {
        return ModelLoader.loadAtom(new StringReader(input));
    }

    public static Atom loadAtom(Reader input) {
        PSLParser parser = null;
        try {
            parser = ModelLoader.getParser(input);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to lex atom.", ex);
        }
        PSLParser.AtomContext atomContext = null;
        try {
            atomContext = parser.atom();
        }
        catch (ParseCancellationException ex) {
            throw (RuntimeException)ex.getCause();
        }
        ModelLoader visitor = new ModelLoader();
        return visitor.visitAtom(atomContext);
    }

    private static PSLParser getParser(Reader input) throws IOException {
        PSLLexer lexer = new PSLLexer(CharStreams.fromReader(input));
        lexer.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) throws ParseCancellationException {
                throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg, ex);
            }
        });
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        PSLParser parser = new PSLParser(tokens);
        parser.setErrorHandler(new BailErrorStrategy());
        return parser;
    }

    private static PSLParser getParser(String input) throws IOException {
        return ModelLoader.getParser(new StringReader(input));
    }

    private ModelLoader() {
    }

    public Model visitProgram(PSLParser.ProgramContext ctx, PSLParser parser) {
        Model model = new Model();
        for (PSLParser.PslRuleContext ruleCtx : ctx.pslRule()) {
            try {
                model.addRule((Rule)this.visit(ruleCtx));
            }
            catch (RuntimeException ex) {
                throw new RuntimeException("Failed to compile rule: [" + parser.getTokenStream().getText(ruleCtx) + "]", ex);
            }
        }
        return model;
    }

    @Override
    public RulePartial visitPslRulePartial(PSLParser.PslRulePartialContext ctx) {
        if (ctx == null || ctx.getChildCount() < 2) {
            throw new IllegalStateException();
        }
        Object ruleCore = this.visit(ctx.getChild(0));
        if (!(ruleCore instanceof Rule || ruleCore instanceof Formula || ruleCore instanceof ArithmeticRuleExpression)) {
            throw new IllegalStateException();
        }
        if (ctx.getChildCount() == 2) {
            return new RulePartial(ruleCore);
        }
        if (!(ruleCore instanceof ArithmeticRuleExpression)) {
            throw new IllegalStateException();
        }
        HashMap<SummationVariable, Formula> filterClauses = new HashMap<SummationVariable, Formula>();
        for (int i = 1; i < ctx.getChildCount() - 1; ++i) {
            FilterClause filterClause = this.visitFilterClause((PSLParser.FilterClauseContext)ctx.getChild(i));
            filterClauses.put(filterClause.v, filterClause.f);
        }
        return new RulePartial((ArithmeticRuleExpression)ruleCore, filterClauses);
    }

    @Override
    public WeightedLogicalRule visitWeightedLogicalRule(PSLParser.WeightedLogicalRuleContext ctx) {
        Float w = this.visitWeightExpression(ctx.weightExpression());
        Formula f = this.visitLogicalRuleExpression(ctx.logicalRuleExpression());
        Boolean sq = false;
        if (ctx.EXPONENT_EXPRESSION() != null) {
            sq = ctx.EXPONENT_EXPRESSION().getText().equals("^2");
        }
        return new WeightedLogicalRule(f, w.floatValue(), sq);
    }

    @Override
    public UnweightedLogicalRule visitUnweightedLogicalRule(PSLParser.UnweightedLogicalRuleContext ctx) {
        Formula f = this.visitLogicalRuleExpression(ctx.logicalRuleExpression());
        return new UnweightedLogicalRule(f);
    }

    @Override
    public Formula visitLogicalRuleExpression(PSLParser.LogicalRuleExpressionContext ctx) {
        if (ctx.logicalDisjunctiveExpression() != null) {
            return this.visitLogicalDisjunctiveExpression(ctx.logicalDisjunctiveExpression());
        }
        if (ctx.logicalImplicationExpression() != null) {
            return this.visitLogicalImplicationExpression(ctx.logicalImplicationExpression());
        }
        throw new IllegalStateException();
    }

    @Override
    public Formula visitLogicalImplicationExpression(PSLParser.LogicalImplicationExpressionContext ctx) {
        Formula body = this.visitLogicalConjunctiveExpression(ctx.logicalConjunctiveExpression());
        Formula head = this.visitLogicalDisjunctiveExpression(ctx.logicalDisjunctiveExpression());
        return new Implication(body, head);
    }

    @Override
    public Formula visitLogicalDisjunctiveExpression(PSLParser.LogicalDisjunctiveExpressionContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.visitLogicalDisjunctiveValue(ctx.logicalDisjunctiveValue());
        }
        Formula lhs = this.visitLogicalDisjunctiveExpression(ctx.logicalDisjunctiveExpression());
        Formula rhs = this.visitLogicalDisjunctiveValue(ctx.logicalDisjunctiveValue());
        return new Disjunction(lhs, rhs).flatten();
    }

    @Override
    public Formula visitLogicalConjunctiveExpression(PSLParser.LogicalConjunctiveExpressionContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.visitLogicalConjunctiveValue(ctx.logicalConjunctiveValue());
        }
        Formula lhs = this.visitLogicalConjunctiveExpression(ctx.logicalConjunctiveExpression());
        Formula rhs = this.visitLogicalConjunctiveValue(ctx.logicalConjunctiveValue());
        return new Conjunction(lhs, rhs).flatten();
    }

    @Override
    public Formula visitLogicalDisjunctiveValue(PSLParser.LogicalDisjunctiveValueContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.visitLogicalNegationValue(ctx.logicalNegationValue());
        }
        return this.visitLogicalDisjunctiveExpression(ctx.logicalDisjunctiveExpression());
    }

    @Override
    public Formula visitLogicalConjunctiveValue(PSLParser.LogicalConjunctiveValueContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.visitLogicalNegationValue(ctx.logicalNegationValue());
        }
        return this.visitLogicalConjunctiveExpression(ctx.logicalConjunctiveExpression());
    }

    @Override
    public Formula visitLogicalNegationValue(PSLParser.LogicalNegationValueContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.visitAtom(ctx.atom());
        }
        if (ctx.getChildCount() == 2) {
            return new Negation(this.visitLogicalNegationValue(ctx.logicalNegationValue()));
        }
        return this.visitLogicalNegationValue(ctx.logicalNegationValue());
    }

    @Override
    public WeightedArithmeticRule visitWeightedArithmeticRule(PSLParser.WeightedArithmeticRuleContext ctx) {
        Float w = this.visitWeightExpression(ctx.weightExpression());
        ArithmeticRuleExpression expression = this.visitArithmeticRuleExpression(ctx.arithmeticRuleExpression());
        HashMap<SummationVariable, Formula> filterClauses = new HashMap<SummationVariable, Formula>();
        for (int i = 0; i < ctx.filterClause().size(); ++i) {
            FilterClause filterClause = this.visitFilterClause(ctx.filterClause(i));
            filterClauses.put(filterClause.v, filterClause.f);
        }
        Boolean sq = false;
        if (ctx.EXPONENT_EXPRESSION() != null) {
            sq = ctx.EXPONENT_EXPRESSION().getText().equals("^2");
        }
        return new WeightedArithmeticRule(expression, filterClauses, w.floatValue(), sq);
    }

    @Override
    public UnweightedArithmeticRule visitUnweightedArithmeticRule(PSLParser.UnweightedArithmeticRuleContext ctx) {
        ArithmeticRuleExpression expression = this.visitArithmeticRuleExpression(ctx.arithmeticRuleExpression());
        HashMap<SummationVariable, Formula> filterClauses = new HashMap<SummationVariable, Formula>();
        for (int i = 0; i < ctx.filterClause().size(); ++i) {
            FilterClause filterClause = this.visitFilterClause(ctx.filterClause(i));
            filterClauses.put(filterClause.v, filterClause.f);
        }
        return new UnweightedArithmeticRule(expression, filterClauses);
    }

    @Override
    public ArithmeticRuleExpression visitArithmeticRuleExpression(PSLParser.ArithmeticRuleExpressionContext ctx) {
        int i;
        LinearArithmeticExpression lhs = this.visitLinearArithmeticExpression((PSLParser.LinearArithmeticExpressionContext)ctx.getChild(0));
        FunctionComparator relationalComparison = this.visitArithmeticRuleRelation((PSLParser.ArithmeticRuleRelationContext)ctx.getChild(1));
        LinearArithmeticExpression rhs = this.visitLinearArithmeticExpression((PSLParser.LinearArithmeticExpressionContext)ctx.getChild(2));
        List<Coefficient> coefficients = lhs.coefficients;
        List<SummationAtomOrAtom> atoms = lhs.atoms;
        Coefficient finalCoefficient = null;
        for (i = 0; i < rhs.atoms.size(); ++i) {
            coefficients.add(new Multiply(new ConstantNumber(-1.0f), rhs.coefficients.get(i)));
            atoms.add(rhs.atoms.get(i));
        }
        if (lhs.nonAtomCoefficient != null) {
            finalCoefficient = new Multiply(new ConstantNumber(-1.0f), lhs.nonAtomCoefficient);
        }
        if (rhs.nonAtomCoefficient != null) {
            finalCoefficient = finalCoefficient == null ? rhs.nonAtomCoefficient : new Add(finalCoefficient, rhs.nonAtomCoefficient);
        }
        if (finalCoefficient == null) {
            finalCoefficient = new ConstantNumber(0.0f);
        }
        for (i = 0; i < coefficients.size(); ++i) {
            coefficients.set(i, coefficients.get(i).simplify());
        }
        finalCoefficient = finalCoefficient.simplify();
        return new ArithmeticRuleExpression(coefficients, atoms, relationalComparison, finalCoefficient);
    }

    @Override
    public LinearArithmeticExpression visitLinearArithmeticExpression(PSLParser.LinearArithmeticExpressionContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.visitLinearArithmeticOperand((PSLParser.LinearArithmeticOperandContext)ctx.getChild(0));
        }
        if (ctx.getChildCount() != 3) {
            throw new IllegalStateException("Expeciting three children.");
        }
        LinearArithmeticExpression lhs = this.visitLinearArithmeticExpression((PSLParser.LinearArithmeticExpressionContext)ctx.getChild(0));
        boolean isAddition = this.visitLinearOperator((PSLParser.LinearOperatorContext)ctx.getChild(1));
        LinearArithmeticExpression rhs = this.visitLinearArithmeticOperand((PSLParser.LinearArithmeticOperandContext)ctx.getChild(2));
        LinearArithmeticExpression expression = lhs;
        for (int i = 0; i < rhs.atoms.size(); ++i) {
            Coefficient coefficient = rhs.coefficients.get(i);
            if (!isAddition) {
                coefficient = new Multiply(new ConstantNumber(-1.0f), coefficient);
            }
            expression.atoms.add(rhs.atoms.get(i));
            expression.coefficients.add(coefficient);
        }
        Coefficient nonAtomCoefficient = null;
        if (lhs.nonAtomCoefficient != null) {
            nonAtomCoefficient = lhs.nonAtomCoefficient;
        }
        if (rhs.nonAtomCoefficient != null) {
            nonAtomCoefficient = nonAtomCoefficient == null ? (isAddition ? rhs.nonAtomCoefficient : new Multiply(new ConstantNumber(-1.0f), rhs.nonAtomCoefficient)) : (isAddition ? new Add(nonAtomCoefficient, rhs.nonAtomCoefficient) : new Subtract(nonAtomCoefficient, rhs.nonAtomCoefficient));
        }
        expression.nonAtomCoefficient = nonAtomCoefficient;
        return expression;
    }

    @Override
    public LinearArithmeticExpression visitLinearArithmeticOperand(PSLParser.LinearArithmeticOperandContext ctx) {
        if (ctx.getChildCount() == 3) {
            return this.visitLinearArithmeticExpression((PSLParser.LinearArithmeticExpressionContext)ctx.getChild(1));
        }
        if (ctx.getChildCount() != 1) {
            throw new IllegalStateException("Expeciting three children.");
        }
        LinearArithmeticExpression expression = new LinearArithmeticExpression();
        ArithmeticCoefficientOperand operand = this.visitArithmeticCoefficientOperand((PSLParser.ArithmeticCoefficientOperandContext)ctx.getChild(0));
        Coefficient coefficient = new ConstantNumber(1.0f);
        if (operand.coefficient != null) {
            coefficient = operand.coefficient;
        }
        if (operand.atom != null) {
            expression.coefficients.add(coefficient);
            expression.atoms.add(operand.atom);
        } else {
            expression.nonAtomCoefficient = coefficient;
        }
        return expression;
    }

    @Override
    public ArithmeticCoefficientOperand visitArithmeticCoefficientOperand(PSLParser.ArithmeticCoefficientOperandContext ctx) {
        ArithmeticCoefficientOperand operand = new ArithmeticCoefficientOperand();
        if (ctx.getChildCount() == 1 && ctx.getChild(0).getPayload() instanceof PSLParser.CoefficientExpressionContext) {
            operand.coefficient = this.visitCoefficientExpression((PSLParser.CoefficientExpressionContext)ctx.getChild(0));
            return operand;
        }
        int atomIndex = 0;
        if (ctx.getChild(0).getPayload() instanceof PSLParser.CoefficientExpressionContext) {
            operand.coefficient = this.visitCoefficientExpression((PSLParser.CoefficientExpressionContext)ctx.getChild(0));
            atomIndex = ctx.getChild(1).getPayload() instanceof CommonToken ? 2 : 1;
        }
        operand.atom = (SummationAtomOrAtom)this.visit(ctx.getChild(atomIndex));
        if (ctx.getChildCount() > atomIndex + 1) {
            Coefficient divisor = this.visitCoefficientExpression((PSLParser.CoefficientExpressionContext)ctx.getChild(atomIndex + 2));
            operand.coefficient = operand.coefficient == null ? new Divide(new ConstantNumber(1.0f), divisor) : new Divide(operand.coefficient, divisor);
        }
        return operand;
    }

    @Override
    public SummationAtomOrAtom visitArithmeticCoefficientOperandAtom(PSLParser.ArithmeticCoefficientOperandAtomContext ctx) {
        if (ctx.getChildCount() == 3) {
            return this.visitArithmeticCoefficientOperandAtom((PSLParser.ArithmeticCoefficientOperandAtomContext)ctx.getChild(1));
        }
        return (SummationAtomOrAtom)this.visit(ctx.getChild(0));
    }

    @Override
    public SummationAtomOrAtom visitSummationAtom(PSLParser.SummationAtomContext ctx) {
        Predicate predicate = this.visitPredicate(ctx.predicate());
        SummationVariableOrTerm[] args = new SummationVariableOrTerm[ctx.getChildCount() / 2 - 1];
        for (int i = 1; i < ctx.getChildCount() / 2; ++i) {
            if (ctx.getChild(i * 2).getPayload() instanceof PSLParser.SummationVariableContext) {
                args[i - 1] = this.visitSummationVariable((PSLParser.SummationVariableContext)ctx.getChild(i * 2).getPayload());
                continue;
            }
            if (ctx.getChild(i * 2).getPayload() instanceof PSLParser.TermContext) {
                args[i - 1] = (Term)this.visit(ctx.getChild(i * 2));
                continue;
            }
            throw new IllegalStateException();
        }
        boolean isSummation = false;
        for (SummationVariableOrTerm arg : args) {
            if (!(arg instanceof SummationVariable)) continue;
            isSummation = true;
            break;
        }
        if (isSummation) {
            return new SummationAtom(predicate, args);
        }
        Term[] termArgs = new Term[args.length];
        for (int i = 0; i < termArgs.length; ++i) {
            termArgs[i] = (Term)args[i];
        }
        return new QueryAtom(predicate, termArgs);
    }

    @Override
    public SummationVariable visitSummationVariable(PSLParser.SummationVariableContext ctx) {
        return new SummationVariable(ctx.IDENTIFIER().getText());
    }

    @Override
    public Coefficient visitCoefficientExpression(PSLParser.CoefficientExpressionContext ctx) {
        return this.visitCoefficientAdditiveExpression((PSLParser.CoefficientAdditiveExpressionContext)ctx.getChild(0));
    }

    @Override
    public Coefficient visitCoefficientAdditiveExpression(PSLParser.CoefficientAdditiveExpressionContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.visitCoefficientMultiplicativeExpression((PSLParser.CoefficientMultiplicativeExpressionContext)ctx.getChild(0));
        }
        Coefficient lhs = this.visitCoefficientAdditiveExpression((PSLParser.CoefficientAdditiveExpressionContext)ctx.getChild(0));
        Coefficient rhs = this.visitCoefficientMultiplicativeExpression((PSLParser.CoefficientMultiplicativeExpressionContext)ctx.getChild(2));
        if (ctx.PLUS() != null) {
            return new Add(lhs, rhs);
        }
        return new Subtract(lhs, rhs);
    }

    @Override
    public Coefficient visitCoefficientMultiplicativeExpression(PSLParser.CoefficientMultiplicativeExpressionContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.visitCoefficient((PSLParser.CoefficientContext)ctx.getChild(0));
        }
        Coefficient lhs = this.visitCoefficientMultiplicativeExpression((PSLParser.CoefficientMultiplicativeExpressionContext)ctx.getChild(0));
        Coefficient rhs = this.visitCoefficient((PSLParser.CoefficientContext)ctx.getChild(2));
        if (ctx.MULT() != null) {
            return new Multiply(lhs, rhs);
        }
        return new Divide(lhs, rhs);
    }

    @Override
    public Coefficient visitCoefficient(PSLParser.CoefficientContext ctx) {
        if (ctx.number() != null) {
            return new ConstantNumber(this.visitNumber(ctx.number()).floatValue());
        }
        if (ctx.getChildCount() == 3) {
            return this.visitCoefficientExpression((PSLParser.CoefficientExpressionContext)ctx.getChild(1));
        }
        return this.visitCoefficientOperator((PSLParser.CoefficientOperatorContext)ctx.getChild(0));
    }

    @Override
    public Coefficient visitCoefficientOperator(PSLParser.CoefficientOperatorContext ctx) {
        if (ctx.getChildCount() == 3) {
            return new Cardinality(new SummationVariable(ctx.variable().getText()));
        }
        return this.visitCoefficientFunction((PSLParser.CoefficientFunctionContext)ctx.getChild(0));
    }

    @Override
    public Coefficient visitCoefficientFunction(PSLParser.CoefficientFunctionContext ctx) {
        Coefficient lhs = this.visitCoefficientExpression((PSLParser.CoefficientExpressionContext)ctx.getChild(2));
        Coefficient rhs = this.visitCoefficientExpression((PSLParser.CoefficientExpressionContext)ctx.getChild(4));
        if (ctx.coefficientFunctionOperator().MAX() != null) {
            return new Max(lhs, rhs);
        }
        return new Min(lhs, rhs);
    }

    @Override
    public FunctionComparator visitArithmeticRuleRelation(PSLParser.ArithmeticRuleRelationContext ctx) {
        if (ctx.EQUAL() != null) {
            return FunctionComparator.EQ;
        }
        if (ctx.LESS_THAN_EQUAL() != null) {
            return FunctionComparator.LTE;
        }
        if (ctx.GREATER_THAN_EQUAL() != null) {
            return FunctionComparator.GTE;
        }
        throw new IllegalStateException();
    }

    @Override
    public Boolean visitLinearOperator(PSLParser.LinearOperatorContext ctx) {
        if (ctx.PLUS() != null) {
            return true;
        }
        if (ctx.MINUS() != null) {
            return false;
        }
        throw new IllegalStateException();
    }

    @Override
    public FilterClause visitFilterClause(PSLParser.FilterClauseContext ctx) {
        FilterClause filter = new FilterClause();
        filter.v = new SummationVariable(ctx.variable().getText());
        filter.f = this.visitBooleanExpression(ctx.booleanExpression());
        return filter;
    }

    @Override
    public Formula visitBooleanValue(PSLParser.BooleanValueContext ctx) {
        if (ctx.logicalNegationValue() != null) {
            return this.visitLogicalNegationValue(ctx.logicalNegationValue());
        }
        return this.visitBooleanExpression(ctx.booleanExpression());
    }

    @Override
    public Formula visitBooleanConjunctiveExpression(PSLParser.BooleanConjunctiveExpressionContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.visitBooleanValue(ctx.booleanValue());
        }
        Formula lhs = this.visitBooleanConjunctiveExpression(ctx.booleanConjunctiveExpression());
        Formula rhs = this.visitBooleanValue(ctx.booleanValue());
        return new Conjunction(lhs, rhs);
    }

    @Override
    public Formula visitBooleanDisjunctiveExpression(PSLParser.BooleanDisjunctiveExpressionContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.visitBooleanConjunctiveExpression(ctx.booleanConjunctiveExpression());
        }
        Formula lhs = this.visitBooleanDisjunctiveExpression(ctx.booleanDisjunctiveExpression());
        Formula rhs = this.visitBooleanConjunctiveExpression(ctx.booleanConjunctiveExpression());
        return new Disjunction(lhs, rhs);
    }

    @Override
    public Formula visitBooleanExpression(PSLParser.BooleanExpressionContext ctx) {
        return this.visitBooleanDisjunctiveExpression(ctx.booleanDisjunctiveExpression());
    }

    @Override
    public Float visitWeightExpression(PSLParser.WeightExpressionContext ctx) {
        return Float.valueOf(Float.parseFloat(ctx.number().getText()));
    }

    @Override
    public Atom visitAtom(PSLParser.AtomContext ctx) {
        if (ctx.predicate() != null) {
            Predicate predicate = this.visitPredicate(ctx.predicate());
            Term[] args = new Term[ctx.term().size()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = (Term)this.visit(ctx.term(i));
            }
            return new QueryAtom(predicate, args);
        }
        if (ctx.termOperator() != null) {
            GroundingOnlyPredicate predicate;
            if (ctx.termOperator().notEqual() != null) {
                predicate = GroundingOnlyPredicate.NotEqual;
            } else if (ctx.termOperator().termEqual() != null) {
                predicate = GroundingOnlyPredicate.Equal;
            } else if (ctx.termOperator().nonSymmetric() != null) {
                predicate = GroundingOnlyPredicate.NonSymmetric;
            } else {
                throw new IllegalStateException();
            }
            return new QueryAtom(predicate, (Term)this.visit(ctx.term(0)), (Term)this.visit(ctx.term(1)));
        }
        throw new IllegalStateException();
    }

    @Override
    public Predicate visitPredicate(PSLParser.PredicateContext ctx) {
        Predicate predicate = Predicate.get(ctx.IDENTIFIER().getText());
        if (predicate != null) {
            return predicate;
        }
        throw new IllegalStateException("Undefined predicate " + ctx.IDENTIFIER().getText());
    }

    @Override
    public Variable visitVariable(PSLParser.VariableContext ctx) {
        return new Variable(ctx.IDENTIFIER().getText());
    }

    @Override
    public Constant visitConstant(PSLParser.ConstantContext ctx) {
        int contextStart = ctx.start.getStartIndex();
        int contextEnd = ctx.stop.getStopIndex();
        Interval interval = new Interval(contextStart, contextEnd);
        String text = ctx.start.getInputStream().getText(interval);
        text = text.substring(1, text.length() - 1);
        text = this.replaceLiterals(text);
        return new StringAttribute(text);
    }

    private String replaceLiterals(String text) {
        if (!text.contains("\\")) {
            return text;
        }
        text = text.replace("\\'", "'");
        text = text.replace("\\\"", "\"");
        text = text.replace("\\t", "\t");
        text = text.replace("\\n", "\n");
        text = text.replace("\\r", "\r");
        text = text.replace("\\\\", "\\");
        return text;
    }

    @Override
    public Float visitNumber(PSLParser.NumberContext ctx) {
        return Float.valueOf(Float.parseFloat(ctx.getText()));
    }

    private static class FilterClause {
        SummationVariable v;
        Formula f;

        private FilterClause() {
        }
    }

    private static class LinearArithmeticExpression {
        public List<Coefficient> coefficients = new LinkedList<Coefficient>();
        public List<SummationAtomOrAtom> atoms = new LinkedList<SummationAtomOrAtom>();
        public Coefficient nonAtomCoefficient = null;
    }

    private static class ArithmeticCoefficientOperand {
        SummationAtomOrAtom atom = null;
        Coefficient coefficient = null;

        private ArithmeticCoefficientOperand() {
        }
    }
}

