/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.parser;

import java.util.Map;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.arithmetic.UnweightedArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.WeightedArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.expression.ArithmeticRuleExpression;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariable;
import org.linqs.psl.model.rule.logical.UnweightedLogicalRule;
import org.linqs.psl.model.rule.logical.WeightedLogicalRule;

public class RulePartial {
    private Rule rule;
    private Formula formula;
    private ArithmeticRuleExpression arithmeticExpression;
    private Map<SummationVariable, Formula> filters;

    public RulePartial(Object ruleCore) {
        if (ruleCore instanceof Rule) {
            this.rule = (Rule)ruleCore;
        } else if (ruleCore instanceof Formula) {
            this.formula = (Formula)ruleCore;
        } else if (ruleCore instanceof ArithmeticRuleExpression) {
            this.arithmeticExpression = (ArithmeticRuleExpression)ruleCore;
        } else {
            throw new IllegalArgumentException(String.format("Expected Rule, Formula, or ArithmeticRuleExpression, got %s.", ruleCore.getClass().getName()));
        }
    }

    public RulePartial(ArithmeticRuleExpression arithmeticExpression, Map<SummationVariable, Formula> filters) {
        this.arithmeticExpression = arithmeticExpression;
        this.filters = filters;
    }

    public boolean isRule() {
        return this.rule != null;
    }

    public Rule toRule() {
        return this.toRule(null, null);
    }

    public Rule toRule(Float weight, Boolean squared) {
        if (weight == null && squared == null) {
            if (this.rule == null) {
                if (this.formula != null) {
                    return this.toUnweightedLogicalRule();
                }
                return this.toUnweightedArithmeticRule();
            }
            return this.rule;
        }
        if (weight != null && squared != null) {
            if (this.rule == null) {
                if (this.formula != null) {
                    return this.toWeightedLogicalRule(weight.floatValue(), squared);
                }
                return this.toWeightedArithmeticRule(weight.floatValue(), squared);
            }
            throw new IllegalArgumentException("The partial is already a full rule, cannot specify weight/squared.");
        }
        throw new IllegalArgumentException("Either both weight and squared must be non-null, or both must be null. Found weight: " + weight + ", squared: " + squared + ".");
    }

    private Rule toUnweightedLogicalRule() {
        return new UnweightedLogicalRule(this.formula);
    }

    private Rule toWeightedLogicalRule(float weight, boolean squared) {
        return new WeightedLogicalRule(this.formula, weight, squared);
    }

    private Rule toUnweightedArithmeticRule() {
        if (this.filters == null) {
            return new UnweightedArithmeticRule(this.arithmeticExpression);
        }
        return new UnweightedArithmeticRule(this.arithmeticExpression, this.filters);
    }

    private Rule toWeightedArithmeticRule(float weight, boolean squared) {
        if (this.filters == null) {
            return new WeightedArithmeticRule(this.arithmeticExpression, weight, squared);
        }
        return new WeightedArithmeticRule(this.arithmeticExpression, this.filters, weight, squared);
    }
}

