/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term;

import java.util.ArrayList;
import java.util.Iterator;
import org.linqs.psl.config.Options;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.util.RandUtils;

public class MemoryTermStore<T extends ReasonerTerm>
implements TermStore<T, GroundAtom> {
    private ArrayList<T> store;

    public MemoryTermStore() {
        this(Options.MEMORY_TS_INITIAL_SIZE.getLong());
    }

    public MemoryTermStore(long initialSize) {
        if (initialSize > Integer.MAX_VALUE) {
            throw new RuntimeException("Initial size (" + initialSize + ") too large for a MemoryTermStore, consider a streaming method.");
        }
        this.store = new ArrayList((int)initialSize);
    }

    @Override
    public synchronized void add(GroundRule rule, T term, Hyperplane hyperplane) {
        this.store.add(term);
    }

    @Override
    public void clear() {
        if (this.store != null) {
            this.store.clear();
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void close() {
        this.clear();
        this.store = null;
    }

    @Override
    public void initForOptimization() {
    }

    @Override
    public void iterationComplete() {
    }

    @Override
    public T get(long index) {
        return (T)((ReasonerTerm)this.store.get((int)index));
    }

    @Override
    public long size() {
        return this.store.size();
    }

    @Override
    public void ensureCapacity(long capacity) {
        assert ((int)capacity >= 0);
        if (capacity == 0L) {
            return;
        }
        this.store.ensureCapacity((int)capacity);
    }

    @Override
    public Iterator<T> iterator() {
        return this.store.iterator();
    }

    @Override
    public Iterator<T> noWriteIterator() {
        return this.iterator();
    }

    @Override
    public GroundAtom createLocalVariable(GroundAtom atom) {
        return atom;
    }

    @Override
    public void ensureVariableCapacity(int capacity) {
    }

    @Override
    public void variablesExternallyUpdated() {
    }

    @Override
    public double syncAtoms() {
        return 0.0;
    }

    public void shuffle() {
        RandUtils.shuffle(this.store);
    }
}

