/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration2.YAMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.linqs.psl.database.DataStore;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.loading.Inserter;
import org.linqs.psl.model.function.ExternalFunction;
import org.linqs.psl.model.predicate.ExternalFunctionalPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.predicate.model.ModelPredicate;
import org.linqs.psl.model.predicate.model.SupportingModel;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.util.FileUtils;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.Reflection;

public class DataLoader {
    public static final String KEY_PREDICATE = "predicates";
    public static final String KEY_PARTITION_OBS = "observations";
    public static final String KEY_PARTITION_TARGETS = "targets";
    public static final String KEY_PARTITION_TRUTH = "truth";
    public static final String PROPERTY_OPEN = "open";
    public static final String PROPERTY_CLOSED = "closed";
    public static final String PROPERTY_TYPES = "types";
    public static final String PROPERTY_BLOCK = "block";
    public static final String PROPERTY_FUNCTION = "implementation";
    public static final String PROPERTY_MODEL_TYPE = "modeltype";
    public static final String PROPERTY_CONFIG = "config";
    public static final Set<String> TOP_LEVEL_PROPS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("predicates", "observations", "targets", "truth")));
    private static final Logger log = Logger.getLogger(DataLoader.class);

    public static Set<StandardPredicate> load(DataStore dataStore, String path, boolean useIntIds) throws ConfigurationException, FileNotFoundException {
        YAMLConfiguration yaml = new YAMLConfiguration();
        yaml.read(FileUtils.getInputStreamReader(path));
        path = new File(path).getAbsolutePath();
        String relativeDir = new File(path).getParentFile().getAbsolutePath();
        DataLoader.validate(yaml);
        Set<StandardPredicate> closedPredicates = DataLoader.parsePredicates(yaml, useIntIds, dataStore, relativeDir);
        DataLoader.loadPartitions(yaml, dataStore, relativeDir);
        return closedPredicates;
    }

    private static void validate(YAMLConfiguration yaml) {
        Iterator<String> keyIterator = yaml.getKeys();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            String[] parts = key.split("\\.", 2);
            if (parts.length < 2) {
                throw new IllegalArgumentException("Bad key in data file: " + key);
            }
            String prefix = parts[0];
            if (TOP_LEVEL_PROPS.contains(prefix)) continue;
            throw new IllegalArgumentException("Unknown top-level key in data file: " + prefix);
        }
    }

    private static void loadPartitions(YAMLConfiguration yaml, DataStore dataStore, String relativeDir) {
        String[] partitions;
        for (String partition : partitions = new String[]{KEY_PARTITION_OBS, KEY_PARTITION_TARGETS, KEY_PARTITION_TRUTH}) {
            Iterator<String> keyIterator = yaml.getKeys(partition);
            while (keyIterator.hasNext()) {
                String key = keyIterator.next();
                Object value = yaml.getProperty(key);
                String predicate = key.replaceFirst("^" + partition + ".", "");
                if (value instanceof String) {
                    DataLoader.loadData(partition, predicate, dataStore, (String)value, relativeDir);
                    continue;
                }
                if (value instanceof List) {
                    List listValues = (List)value;
                    for (Object listValue : listValues) {
                        if (!(listValue instanceof String)) {
                            throw new IllegalArgumentException(String.format("Expected a string property to key, %s, found: '%s'.", key, listValue.getClass().getName()));
                        }
                        DataLoader.loadData(partition, predicate, dataStore, (String)listValue, relativeDir);
                    }
                    continue;
                }
                throw new IllegalArgumentException(String.format("Key, %s, has an unrecognized type: '%s'.", key, value.getClass().getName()));
            }
        }
    }

    private static void loadData(String partitionName, String predicateName, DataStore dataStore, String path, String relativeDir) {
        Predicate rawPredicate = Predicate.get(predicateName);
        if (rawPredicate == null) {
            throw new IllegalArgumentException(String.format("Non-existent predicate (%s) declared in the %s partition without first being defined in the 'predicates' section of the data file.", predicateName, partitionName));
        }
        if (rawPredicate instanceof ExternalFunctionalPredicate) {
            throw new IllegalArgumentException(String.format("Cannot load data into a function predicate (%s). See %s partition in the data file.", predicateName, partitionName));
        }
        Partition partition = dataStore.getPartition(partitionName);
        StandardPredicate predicate = StandardPredicate.get(predicateName);
        log.debug("Loading data for {} ({} partition)", predicateName, partitionName);
        Inserter insert = dataStore.getInserter(predicate, partition);
        insert.loadDelimitedDataAutomatic(DataLoader.makePath(relativeDir, path));
    }

    private static Set<StandardPredicate> parsePredicates(YAMLConfiguration yaml, boolean useIntIds, DataStore dataStore, String relativeDir) {
        HashSet<StandardPredicate> closedPredicates = new HashSet<StandardPredicate>();
        HashMap predicateProperties = new HashMap();
        Iterator<String> keyIterator = yaml.getKeys(KEY_PREDICATE);
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            String predicateName = key.replaceFirst("^predicates.", "");
            Object rawValue = yaml.getProperty(key);
            if (predicateName.contains(".")) {
                String[] parts = predicateName.split("\\.");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Unknown key structure: '" + key + "'.");
                }
                predicateName = parts[0];
                String subKey = parts[1];
                if (!predicateProperties.containsKey(predicateName)) {
                    predicateProperties.put(predicateName, new ArrayList());
                }
                HashMap<String, Object> subKeyMap = new HashMap<String, Object>();
                subKeyMap.put(subKey, rawValue);
                ((List)predicateProperties.get(predicateName)).add(subKeyMap);
                continue;
            }
            if (!predicateProperties.containsKey(predicateName)) {
                predicateProperties.put(predicateName, new ArrayList());
            }
            if (rawValue instanceof String) {
                ((List)predicateProperties.get(predicateName)).add(yaml.getProperty(key));
                continue;
            }
            if (!(rawValue instanceof List)) continue;
            for (Object value : (List)rawValue) {
                ((List)predicateProperties.get(predicateName)).add(value);
            }
        }
        if (predicateProperties.size() == 0) {
            throw new IllegalStateException(String.format("Found no predicates. Predicates must be defined under the '%s' key.", KEY_PREDICATE));
        }
        for (Map.Entry entry : predicateProperties.entrySet()) {
            DataLoader.parsePredicate((String)entry.getKey(), (List)entry.getValue(), useIntIds, dataStore, closedPredicates, relativeDir);
        }
        return closedPredicates;
    }

    /*
     * WARNING - void declaration
     */
    private static void parsePredicate(String name, List<Object> properties, boolean useIntIds, DataStore dataStore, Set<StandardPredicate> closedPredicates, String relativeDir) {
        int arity = -1;
        Boolean isClosed = null;
        boolean isBlock = false;
        String externalFunctionImplementation = null;
        String modelType = null;
        HashMap<String, String> config = new HashMap<String, String>();
        ArrayList<ConstantType> types = new ArrayList<ConstantType>();
        if (name.contains("/")) {
            String[] parts = name.split("/");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Predicate names may not contain a slash. Offending name: '" + name + "'.");
            }
            name = parts[0];
            arity = Integer.parseInt(parts[1]);
        }
        for (Object e : properties) {
            if (e instanceof String) {
                String stringProperty = (String)e;
                if (stringProperty.equals(PROPERTY_OPEN)) {
                    isClosed = false;
                    continue;
                }
                if (stringProperty.equals(PROPERTY_CLOSED)) {
                    isClosed = true;
                    continue;
                }
                if (stringProperty.equals(PROPERTY_BLOCK)) {
                    isBlock = true;
                    continue;
                }
                throw new IllegalStateException(String.format("Predicate, %s, has an unknown property: '%s'.", name, stringProperty));
            }
            if (e instanceof Map) {
                Map mapProperty = (Map)e;
                for (Map.Entry propEntry : mapProperty.entrySet()) {
                    String key = (String)propEntry.getKey();
                    Object rawValue = propEntry.getValue();
                    if (key.equals(PROPERTY_TYPES)) {
                        if (rawValue instanceof String) {
                            types.add(ConstantType.valueOf((String)rawValue));
                        } else if (rawValue instanceof List) {
                            List rawTypes = (List)rawValue;
                            for (String string : rawTypes) {
                                types.add(ConstantType.valueOf(string));
                            }
                        } else {
                            throw new IllegalArgumentException(String.format("Predicate, %s, has an unknown type representation (expecting string or list).", name));
                        }
                        if (arity != -1 && arity != types.size()) {
                            throw new IllegalArgumentException(String.format("Size mismatch on predicate %s. Declared arity: %d. Length of supplied types: %d.", name, arity, types.size()));
                        }
                        arity = types.size();
                        continue;
                    }
                    if (key.equals(PROPERTY_FUNCTION)) {
                        if (!(rawValue instanceof String)) {
                            throw new IllegalStateException(String.format("Predicate, %s, has a function with an unknown type (%s). The value should be the target class name (as a string).", name, rawValue.getClass().getName()));
                        }
                        externalFunctionImplementation = (String)rawValue;
                        continue;
                    }
                    if (key.equals(PROPERTY_MODEL_TYPE)) {
                        if (!(rawValue instanceof String)) {
                            throw new IllegalStateException(String.format("Predicate, %s, has a model type key with an unknown type (%s), should be a string.", name, rawValue.getClass().getName()));
                        }
                        modelType = (String)rawValue;
                        continue;
                    }
                    if (key.equals(PROPERTY_CONFIG)) {
                        if (!(rawValue instanceof Map)) {
                            throw new IllegalStateException(String.format("Predicate, %s, has a config key with an unknown type (%s), should be a Map<String, String>.", name, rawValue.getClass().getName()));
                        }
                        Map rawMap = (Map)rawValue;
                        for (Map.Entry entry : rawMap.entrySet()) {
                            config.put((String)entry.getKey(), entry.getValue().toString());
                        }
                        continue;
                    }
                    throw new IllegalStateException(String.format("Predicate, %s, has an unknown property: '%s'.", name, key));
                }
                continue;
            }
            throw new IllegalStateException(String.format("Property of predicate, %s, has an unknown type: %s.", name, e.getClass().getName()));
        }
        if (externalFunctionImplementation != null) {
            if (isBlock) {
                throw new IllegalArgumentException(String.format("Functional predicates (%s) cannot be blocks.", new Object[0]));
            }
            ExternalFunctionalPredicate.get(name, (ExternalFunction)Reflection.newObject(externalFunctionImplementation));
            return;
        }
        if (arity == -1) {
            throw new IllegalArgumentException(String.format("Could not find arity for predicate: %s", name));
        }
        if (isClosed == null) {
            throw new IllegalArgumentException(String.format("Closed/open not specified for predicate: %s", name));
        }
        if (types.size() == 0) {
            for (int i = 0; i < arity; ++i) {
                if (useIntIds) {
                    types.add(ConstantType.UniqueIntID);
                    continue;
                }
                types.add(ConstantType.UniqueStringID);
            }
        }
        StandardPredicate predicate = null;
        if (modelType != null) {
            void var14_19;
            String string;
            String string2 = Reflection.resolveClassName(modelType);
            if (string2 == null && (string = Reflection.resolveClassName("org.linqs.psl.model.predicate.model." + modelType)) == null) {
                throw new IllegalArgumentException("Unable to resolve the model type: " + modelType);
            }
            SupportingModel model = (SupportingModel)Reflection.newObject((String)var14_19);
            predicate = ModelPredicate.get(name, model, types.toArray(new ConstantType[0]));
            ((ModelPredicate)predicate).loadModel(config, relativeDir);
        } else {
            predicate = StandardPredicate.get(name, types.toArray(new ConstantType[0]));
        }
        predicate.setBlock(isBlock);
        dataStore.registerPredicate(predicate);
        if (isClosed.booleanValue()) {
            closedPredicates.add(predicate);
            if (predicate instanceof ModelPredicate) {
                throw new IllegalArgumentException(String.format("Model predicates (%s) cannot be closed.", predicate));
            }
        }
    }

    private static String makePath(String relativeDir, String basePath) {
        if (Paths.get(basePath, new String[0]).isAbsolute()) {
            return basePath;
        }
        return Paths.get(relativeDir, basePath).toString();
    }
}

