/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.util.Arrays;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static double[] ensureCapacity(double[] array, int capacity) {
        assert (capacity >= 0);
        if (array.length <= capacity) {
            array = Arrays.copyOf(array, (capacity + 1) * 2);
        }
        return array;
    }

    public static float[] ensureCapacity(float[] array, int capacity) {
        assert (capacity >= 0);
        if (array.length <= capacity) {
            array = Arrays.copyOf(array, (capacity + 1) * 2);
        }
        return array;
    }

    public static int[] ensureCapacity(int[] array, int capacity) {
        assert (capacity >= 0);
        if (array.length <= capacity) {
            array = Arrays.copyOf(array, (capacity + 1) * 2);
        }
        return array;
    }

    public static <T> T[] ensureCapacity(T[] array, int capacity) {
        assert (capacity >= 0);
        if (array.length <= capacity) {
            array = Arrays.copyOf(array, (capacity + 1) * 2);
        }
        return array;
    }

    public static <T> int indexOf(T[] haystack, T needle) {
        if (haystack == null) {
            return -1;
        }
        return ArrayUtils.indexOf(haystack, haystack.length, needle);
    }

    public static <T> int indexOf(T[] haystack, int size, T needle) {
        if (haystack == null) {
            return -1;
        }
        for (int i = 0; i < size; ++i) {
            if (haystack[i] == null || !haystack[i].equals(needle)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOfReference(T[] haystack, T needle) {
        if (haystack == null) {
            return -1;
        }
        return ArrayUtils.indexOfReference(haystack, haystack.length, needle);
    }

    public static <T> int indexOfReference(T[] haystack, int size, T needle) {
        if (haystack == null) {
            return -1;
        }
        for (int i = 0; i < size; ++i) {
            if (haystack[i] == null || haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }
}

