/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.LAPACK;
import java.util.Arrays;
import org.linqs.psl.util.HashCode;
import org.linqs.psl.util.MathUtils;
import org.netlib.util.intW;

public final class FloatMatrix {
    private float[] data;
    private int numRows;
    private int numCols;

    public FloatMatrix() {
        this.data = null;
        this.numRows = 0;
        this.numCols = 0;
    }

    public FloatMatrix(float[] data, int numRows, int numCols) {
        this(data, numRows, numCols, true);
    }

    public FloatMatrix(float[] data, int numRows, int numCols, boolean copy) {
        if (data.length != numRows * numCols) {
            throw new IllegalArgumentException(String.format("Length of data (%d) and size of matrix (%d x %d = %d) does not match.", data.length, numRows, numCols, numRows * numCols));
        }
        this.numRows = numRows;
        this.numCols = numCols;
        this.data = copy ? Arrays.copyOf(data, data.length) : data;
    }

    public FloatMatrix(float[][] gridData) {
        if (gridData == null || gridData.length == 0) {
            this.data = null;
            this.numRows = 0;
            this.numCols = 0;
            return;
        }
        this.numRows = gridData.length;
        this.numCols = gridData[0].length;
        this.data = new float[this.numRows * this.numCols];
        for (int row = 0; row < this.numRows; ++row) {
            if (gridData[row].length != this.numCols) {
                throw new IllegalArgumentException(String.format("Matrix does not have consistent number of columns. Expecting %d, found %d (row %d).", this.numCols, gridData[row].length, row));
            }
            for (int col = 0; col < this.numCols; ++col) {
                this.data[col * this.numRows + row] = gridData[row][col];
            }
        }
    }

    public void assume(float[] data, int numRows, int numCols) {
        this.data = data;
        this.numRows = numRows;
        this.numCols = numCols;
    }

    public static FloatMatrix zeroes(int numRows, int numCols) {
        return new FloatMatrix(new float[numRows * numCols], numRows, numCols);
    }

    public static FloatMatrix ones(int numRows, int numCols) {
        float[] data = new float[numRows * numCols];
        for (int i = 0; i < numRows * numCols; ++i) {
            data[i] = 1.0f;
        }
        return new FloatMatrix(data, numRows, numCols, false);
    }

    public static FloatMatrix eye(int size) {
        float[] data = new float[size * size];
        for (int i = 0; i < size; ++i) {
            data[i * (size + 1)] = 1.0f;
        }
        return new FloatMatrix(data, size, size, false);
    }

    public static FloatMatrix columnVector(float[] data) {
        return FloatMatrix.columnVector(data, true);
    }

    public static FloatMatrix columnVector(float[] data, boolean copy) {
        return new FloatMatrix(data, data.length, 1, copy);
    }

    public static FloatMatrix rowVector(float[] data) {
        return FloatMatrix.rowVector(data, true);
    }

    public static FloatMatrix rowVector(float[] data, boolean copy) {
        return new FloatMatrix(data, 1, data.length, copy);
    }

    public FloatMatrix copy() {
        return new FloatMatrix(Arrays.copyOf(this.data, this.data.length), this.numRows, this.numCols, false);
    }

    public float[][] asGrid() {
        float[][] rtn = new float[this.numRows][this.numCols];
        for (int row = 0; row < this.numRows; ++row) {
            for (int col = 0; col < this.numCols; ++col) {
                rtn[row][col] = this.data[col * this.numRows + row];
            }
        }
        return rtn;
    }

    public float[] asColumnArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public float[] asRowArray() {
        float[] rtn = new float[this.size()];
        for (int row = 0; row < this.numRows; ++row) {
            for (int col = 0; col < this.numCols; ++col) {
                rtn[row * this.numCols + col] = this.data[col * this.numRows + row];
            }
        }
        return rtn;
    }

    public float get(int row, int col) {
        return this.data[col * this.numRows + row];
    }

    public void set(int row, int col, float value) {
        this.data[col * this.numRows + row] = value;
    }

    public int size() {
        return this.numRows * this.numCols;
    }

    public int numRows() {
        return this.numRows;
    }

    public int numCols() {
        return this.numCols;
    }

    public int hashCode() {
        return HashCode.build(HashCode.build(this.numRows), this.numCols);
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null || !(otherObj instanceof FloatMatrix)) {
            return false;
        }
        FloatMatrix other = (FloatMatrix)otherObj;
        if (this.numRows != other.numRows || this.numCols != other.numCols) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (MathUtils.equals(this.data[i], other.data[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.data == null || this.numRows == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < this.numRows; ++i) {
            builder.append("[");
            for (int j = 0; j < this.numCols; ++j) {
                builder.append(this.get(i, j));
                if (j == this.numCols - 1) continue;
                builder.append(", ");
            }
            builder.append("]");
            if (i == this.numRows - 1) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    public FloatMatrix elementSub(FloatMatrix other) {
        return this.elementSub(other, false);
    }

    public FloatMatrix elementSub(FloatMatrix other, boolean inPlace) {
        assert (this.numRows == other.numRows);
        assert (this.numCols == other.numCols);
        float[] result = inPlace ? this.data : new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.data[i] - other.data[i];
        }
        if (inPlace) {
            return this;
        }
        return new FloatMatrix(result, this.numRows, this.numCols, false);
    }

    public FloatMatrix elementAdd(FloatMatrix other) {
        return this.elementAdd(other, false);
    }

    public FloatMatrix elementAdd(FloatMatrix other, boolean inPlace) {
        assert (this.numRows == other.numRows);
        assert (this.numCols == other.numCols);
        float[] result = inPlace ? this.data : new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.data[i] + other.data[i];
        }
        if (inPlace) {
            return this;
        }
        return new FloatMatrix(result, this.numRows, this.numCols, false);
    }

    public FloatMatrix elementMul(FloatMatrix other) {
        return this.elementMul(other, false);
    }

    public FloatMatrix elementMul(FloatMatrix other, boolean inPlace) {
        assert (this.numRows == other.numRows);
        assert (this.numCols == other.numCols);
        float[] result = inPlace ? this.data : new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.data[i] * other.data[i];
        }
        if (inPlace) {
            return this;
        }
        return new FloatMatrix(result, this.numRows, this.numCols, false);
    }

    public FloatMatrix elementDiv(FloatMatrix other) {
        return this.elementDiv(other, false);
    }

    public FloatMatrix elementDiv(FloatMatrix other, boolean inPlace) {
        assert (this.numRows == other.numRows);
        assert (this.numCols == other.numCols);
        float[] result = inPlace ? this.data : new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.data[i] / other.data[i];
        }
        if (inPlace) {
            return this;
        }
        return new FloatMatrix(result, this.numRows, this.numCols, false);
    }

    public FloatMatrix elementLog() {
        return this.elementLog(false);
    }

    public FloatMatrix elementLog(boolean inPlace) {
        float[] result = inPlace ? this.data : new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = (float)Math.log(this.data[i]);
        }
        if (inPlace) {
            return this;
        }
        return new FloatMatrix(result, this.numRows, this.numCols, false);
    }

    public FloatMatrix sub(float val) {
        return this.sub(val, false);
    }

    public FloatMatrix sub(float val, boolean inPlace) {
        float[] result = inPlace ? this.data : new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.data[i] - val;
        }
        if (inPlace) {
            return this;
        }
        return new FloatMatrix(result, this.numRows, this.numCols, false);
    }

    public FloatMatrix add(float val) {
        return this.add(val, false);
    }

    public FloatMatrix add(float val, boolean inPlace) {
        float[] result = inPlace ? this.data : new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.data[i] + val;
        }
        if (inPlace) {
            return this;
        }
        return new FloatMatrix(result, this.numRows, this.numCols, false);
    }

    public FloatMatrix mul(float val) {
        return this.mul(val, false);
    }

    public FloatMatrix mul(float val, boolean inPlace) {
        float[] result = inPlace ? this.data : new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.data[i] * val;
        }
        if (inPlace) {
            return this;
        }
        return new FloatMatrix(result, this.numRows, this.numCols, false);
    }

    public FloatMatrix div(float val) {
        return this.div(val, false);
    }

    public FloatMatrix div(float val, boolean inPlace) {
        float[] result = inPlace ? this.data : new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.data[i] / val;
        }
        if (inPlace) {
            return this;
        }
        return new FloatMatrix(result, this.numRows, this.numCols, false);
    }

    public float norm1() {
        float sum = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            sum += Math.abs(this.data[i]);
        }
        return sum;
    }

    public float norm2() {
        float sum = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            sum = (float)((double)sum + Math.pow(this.data[i], 2.0));
        }
        return (float)Math.sqrt(sum);
    }

    public FloatMatrix transpose() {
        FloatMatrix result = FloatMatrix.zeroes(this.numCols, this.numRows);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                result.set(j, i, this.get(i, j));
            }
        }
        return result;
    }

    public FloatMatrix mul(FloatMatrix b) {
        return this.mul(b, false, false, 1.0f);
    }

    public FloatMatrix mul(FloatMatrix b, boolean transposeA, boolean transposeB, float alpha) {
        return this.mul(b, null, transposeA, transposeB, alpha, 0.0f);
    }

    public FloatMatrix mul(FloatMatrix b, FloatMatrix c, boolean transposeA, boolean transposeB, float alpha, float beta) {
        return this.blas_sgemm(b, c, transposeA, transposeB, alpha, beta);
    }

    public float dot(FloatMatrix other) {
        return this.blas_sdot(other);
    }

    public FloatMatrix inverse() {
        if (this.numRows != this.numCols) {
            throw new IllegalArgumentException(String.format("Cannot invert a non-square matrix (%d x %d).", this.numRows, this.numCols));
        }
        FloatMatrix dataCopy = this.copy();
        FloatMatrix identity = FloatMatrix.eye(this.numRows);
        try {
            dataCopy.lapack_sgesv(identity);
        }
        catch (ArithmeticException ex) {
            throw new ArithmeticException("Non-invertible matrix: " + this.toString());
        }
        return identity;
    }

    public FloatMatrix choleskyDecomposition() {
        return this.choleskyDecomposition(false);
    }

    public FloatMatrix choleskyDecomposition(boolean inPlace) {
        FloatMatrix result = this;
        if (!inPlace) {
            result = this.copy();
        }
        result.lapack_spotrf(false);
        return result;
    }

    public int[] lapack_sgesv(FloatMatrix b) {
        if (this.numRows != this.numCols) {
            throw new IllegalArgumentException(String.format("sgesv requires a square A matrix, got (%d x %d).", this.numRows, this.numCols));
        }
        int[] pivots = new int[this.numRows];
        intW result = new intW(0);
        LAPACK.getInstance().sgesv(this.numRows, b.numCols, this.data, this.numRows, pivots, b.data, b.numRows, result);
        if (result.val < 0) {
            throw new IllegalArgumentException(String.format("Error in the %d argument to sgesv.", result.val * -1));
        }
        if (result.val > 0) {
            throw new ArithmeticException(String.format("Error in sgesv. U(%d, %d) is singular, so the solution could not be computed.", result.val, result.val));
        }
        return pivots;
    }

    public void lapack_spotrf(boolean upper) {
        if (this.numRows != this.numCols) {
            throw new IllegalArgumentException(String.format("spotrf requires a square A matrix, got (%d x %d).", this.numRows, this.numCols));
        }
        String uplo = "U";
        if (!upper) {
            uplo = "L";
        }
        intW result = new intW(0);
        LAPACK.getInstance().spotrf(uplo, this.numRows, this.data, this.numRows, result);
        if (result.val < 0) {
            throw new IllegalArgumentException(String.format("Error in the %d argument to spotrf.", result.val * -1));
        }
        if (result.val > 0) {
            throw new ArithmeticException(String.format("Error in spotrf (%d). Matrix is not positive definite.", result.val));
        }
    }

    public FloatMatrix blas_sgemm(FloatMatrix b, FloatMatrix c, boolean transposeA, boolean transposeB, float alpha, float beta) {
        String transA = "N";
        int aNumRows = this.numRows;
        int aNumCols = this.numCols;
        String transB = "N";
        int bNumRows = b.numRows;
        int bNumCols = b.numCols;
        if (transposeA) {
            transA = "T";
            aNumRows = this.numCols;
            aNumCols = this.numRows;
        }
        if (transposeB) {
            transB = "T";
            bNumRows = b.numCols;
            bNumCols = b.numRows;
        }
        if (aNumCols != bNumRows) {
            throw new IllegalArgumentException(String.format("Cannot multiply matrices of (post transposed) dimensions (%d x %d) and (%d x %d).", this.numRows, this.numCols, b.numRows, b.numCols));
        }
        if (c == null) {
            c = FloatMatrix.zeroes(aNumRows, bNumCols);
            beta = 0.0f;
        }
        BLAS.getInstance().sgemm(transA, transB, aNumRows, bNumCols, aNumCols, alpha, this.data, aNumRows, b.data, bNumRows, beta, c.data, c.numRows);
        return c;
    }

    public float blas_sdot(FloatMatrix y) {
        if (this.numRows != 1 && this.numCols != 1 || y.numRows != 1 && y.numCols != 1) {
            throw new IllegalArgumentException(String.format("sdot only works with vectors. Got (%d x %d) and (%d x %d).", this.numRows, this.numCols, y.numRows, y.numCols));
        }
        if (this.size() != y.size()) {
            throw new IllegalArgumentException(String.format("sdot only works with same sized vectors. Got %d and %d.", this.size(), y.size()));
        }
        float dot = BLAS.getInstance().sdot(this.size(), this.data, 1, y.data, 1);
        return dot;
    }
}

