/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.math.BigInteger;

public final class MathUtils {
    public static final double EPSILON = 1.0E-6;
    public static final double RELAXED_EPSILON = 0.005;
    public static final double STRICT_EPSILON = 1.0E-8;
    public static final float EPSILON_FLOAT = 1.0E-4f;
    public static final float RELAXED_EPSILON_FLOAT = 0.005f;
    public static final float STRICT_EPSILON_FLOAT = 1.0E-6f;

    private MathUtils() {
    }

    public static boolean signsMatch(int a, int b) {
        return a > 0 && b > 0 || a < 0 && b < 0 || a == 0 && b == 0;
    }

    public static boolean signsMatch(float a, float b) {
        return a > 0.0f && b > 0.0f || a < 0.0f && b < 0.0f || MathUtils.isZero(a) && MathUtils.isZero(b);
    }

    public static boolean signsMatch(double a, double b) {
        return a > 0.0 && b > 0.0 || a < 0.0 && b < 0.0 || MathUtils.isZero(a) && MathUtils.isZero(b);
    }

    public static int compare(int a, int b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public static boolean equals(double a, double b) {
        return MathUtils.equals(a, b, 1.0E-6);
    }

    public static boolean equalsRelaxed(double a, double b) {
        return MathUtils.equals(a, b, 0.005);
    }

    public static boolean equalsStrict(double a, double b) {
        return MathUtils.equals(a, b, 1.0E-8);
    }

    public static boolean equals(double a, double b, double epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public static int compare(double a, double b) {
        return MathUtils.compare(a, b, 1.0E-6);
    }

    public static int compare(double a, double b, double epsilon) {
        if (MathUtils.equals(a, b, epsilon)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public static boolean isZero(double a) {
        return MathUtils.equals(a, 0.0);
    }

    public static boolean isZero(double a, double epsilon) {
        return MathUtils.equals(a, 0.0, epsilon);
    }

    public static boolean equals(float a, float b) {
        return MathUtils.equals(a, b, 1.0E-4f);
    }

    public static boolean equalsRelaxed(float a, float b) {
        return MathUtils.equals(a, b, 0.005f);
    }

    public static boolean equalsStrict(float a, float b) {
        return MathUtils.equals(a, b, 1.0E-6f);
    }

    public static boolean equals(float a, float b, float epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public static int compare(float a, float b) {
        return MathUtils.compare(a, b, 1.0E-4f);
    }

    public static int compare(float a, float b, float epsilon) {
        if (MathUtils.equals(a, b, epsilon)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public static boolean isZero(float a) {
        return MathUtils.equals(a, 0.0f);
    }

    public static boolean isZero(float a, float epsilon) {
        return MathUtils.equals(a, 0.0f, epsilon);
    }

    public static int smallFactorial(int number) {
        if (number >= 16) {
            throw new IllegalArgumentException("Too large a number for smallFactorial: " + number);
        }
        int result = 1;
        for (int factor = 2; factor <= number; ++factor) {
            result *= factor;
        }
        return result;
    }

    public static BigInteger factorial(BigInteger number) {
        BigInteger result = BigInteger.valueOf(1L);
        for (long factor = 2L; factor <= number.longValue(); ++factor) {
            result = result.multiply(BigInteger.valueOf(factor));
        }
        return result;
    }

    public static void toUnit(double[] vector) {
        MathUtils.toMagnitude(vector, 1.0);
    }

    public static void toUnit(float[] vector) {
        MathUtils.toMagnitude(vector, 1.0);
    }

    public static void toMagnitude(double[] vector, double magnitude) {
        if (magnitude <= 0.0) {
            throw new ArithmeticException("Cannot scale a vector to a non-positive magnitude.");
        }
        double norm = MathUtils.pNorm(vector, 2.0);
        if (norm == 0.0 && vector.length != 0) {
            throw new ArithmeticException("Cannot scale a zero vector to a non-zero magnitude.");
        }
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = magnitude * (vector[i] / norm);
        }
    }

    public static void toMagnitude(float[] vector, double magnitude) {
        if (magnitude <= 0.0) {
            throw new ArithmeticException("Cannot scale a vector to a non-positive magnitude.");
        }
        float norm = MathUtils.pNorm(vector, 2.0f);
        if ((double)norm == 0.0 && vector.length != 0) {
            throw new ArithmeticException("Cannot scale a zero vector to a non-zero magnitude.");
        }
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = (float)(magnitude * (double)(vector[i] / norm));
        }
    }

    public static float pNorm(float[] vector, float p) {
        float norm = 0.0f;
        if (p <= 0.0f) {
            throw new ArithmeticException("The p-norm for p <= 0.0 is not defined.");
        }
        if (p == Float.POSITIVE_INFINITY) {
            for (float v : vector) {
                if (!(norm < Math.abs(v))) continue;
                norm = Math.abs(v);
            }
            return norm;
        }
        for (float v : vector) {
            norm = (float)((double)norm + Math.pow(v, p));
        }
        norm = (float)Math.pow(norm, 1.0f / p);
        return norm;
    }

    public static double pNorm(double[] vector, double p) {
        double norm = 0.0;
        if (p <= 0.0) {
            throw new ArithmeticException("The p-norm for p <= 0.0 is not defined.");
        }
        if (p == Double.POSITIVE_INFINITY) {
            for (double v : vector) {
                if (!(norm < Math.abs(v))) continue;
                norm = Math.abs(v);
            }
            return norm;
        }
        for (double v : vector) {
            norm += Math.pow(v, p);
        }
        norm = Math.pow(norm, 1.0 / p);
        return norm;
    }
}

