/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.search.grid;

import java.util.List;
import org.linqs.psl.application.learning.weight.search.grid.BaseGridSearch;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.StringUtils;

public class GridSearch
extends BaseGridSearch {
    private static final Logger log = Logger.getLogger(GridSearch.class);
    protected final float[] possibleWeights = StringUtils.splitFloat(Options.WLA_GS_POSSIBLE_WEIGHTS.getString(), ":");

    public GridSearch(List<Rule> rules, Database trainTargetDatabase, Database trainTruthDatabase, Database validationTargetDatabase, Database validationTruthDatabase, boolean runValidation) {
        super(rules, trainTargetDatabase, trainTruthDatabase, validationTargetDatabase, validationTruthDatabase, runValidation);
        if (this.possibleWeights.length == 0) {
            throw new IllegalArgumentException("No weights provided for grid search.");
        }
        this.numLocations = this.maxNumLocations = (int)Math.pow(this.possibleWeights.length, this.mutableRules.size());
    }

    @Override
    protected void getWeights(float[] weights) {
        int[] indexes = StringUtils.splitInt(this.currentLocation, ":");
        assert (indexes.length == this.mutableRules.size());
        for (int i = 0; i < this.mutableRules.size(); ++i) {
            weights[i] = this.possibleWeights[indexes[i]];
        }
    }

    @Override
    protected boolean chooseNextLocation() {
        if (this.currentLocation == null) {
            this.currentLocation = StringUtils.join(":", new int[this.mutableRules.size()]);
            return true;
        }
        int[] indexes = StringUtils.splitInt(this.currentLocation, ":");
        assert (indexes.length == this.mutableRules.size());
        for (int i = this.mutableRules.size() - 1; i >= 0; --i) {
            int n = i;
            indexes[n] = indexes[n] + 1;
            if (indexes[i] != this.possibleWeights.length) break;
            indexes[i] = 0;
        }
        this.currentLocation = StringUtils.join(":", indexes);
        return true;
    }
}

