/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.config;

import java.io.BufferedReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.linqs.psl.util.FileUtils;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.Reflection;
import org.linqs.psl.util.RuntimeStats;

public class Config {
    public static final String CLASS_LIST_PROPS = "classlist.properties";
    public static final String GIT_PROPS = "git.properties";
    public static final String PROJECT_PROPS = "project.properties";
    public static final String CLASS_LIST_KEY = "classlist.classes";
    private static final Logger log = Logger.getLogger(Config.class);
    private static Deque<Map<String, Object>> layers = null;

    public static void init() {
        layers = new LinkedList<Map<String, Object>>();
        Config.pushLayer();
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(PROJECT_PROPS);
        if (stream != null) {
            Config.loadProperties(stream, PROJECT_PROPS);
        }
        if ((stream = ClassLoader.getSystemClassLoader().getResourceAsStream(GIT_PROPS)) != null) {
            Config.loadProperties(stream, GIT_PROPS);
        }
        if ((stream = ClassLoader.getSystemClassLoader().getResourceAsStream(CLASS_LIST_PROPS)) != null) {
            Config.loadClassList(stream, CLASS_LIST_PROPS);
        }
    }

    public static void pushLayer() {
        layers.push(new HashMap());
    }

    public static Map<String, Object> popLayer() {
        if (layers.size() == 1) {
            throw new IllegalStateException("Attempt to pop the only Config layer.");
        }
        return layers.pop();
    }

    public static void loadProperties(InputStream stream, String resourceName) {
        try (BufferedReader reader = FileUtils.getBufferedReader(stream);){
            for (String line : FileUtils.lines(reader)) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                String[] parts = line.split("=", 2);
                if (parts.length != 2) {
                    throw new IllegalArgumentException(String.format("Bad properties format for resource %s. Offending line: '%s'.", resourceName, line));
                }
                Config.setProperty(parts[0], parts[1], false);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load config resource: " + resourceName, ex);
        }
        log.debug("Configuration resource loaded: {}", resourceName);
        RuntimeStats.collect();
    }

    public static void loadClassList(InputStream stream, String resourceName) {
        ArrayList<String> classNames = new ArrayList<String>();
        try (BufferedReader reader = FileUtils.getBufferedReader(stream);){
            for (String line : FileUtils.lines(reader)) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                String[] parts = line.split("=", 2);
                if (parts.length != 2) {
                    throw new IllegalArgumentException(String.format("Bad properties format for resource %s. Offending line: '%s'.", resourceName, line));
                }
                if (!parts[0].equals(CLASS_LIST_KEY)) {
                    throw new IllegalArgumentException(String.format("Unknown key (%s) found in classlist. Expecting only '%s'.", parts[0], CLASS_LIST_KEY));
                }
                classNames.add(parts[1]);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load config resource: " + resourceName, ex);
        }
        Config.setProperty(CLASS_LIST_KEY, classNames, false);
        log.debug("Configuration resource loaded: {}", resourceName);
        RuntimeStats.collect();
    }

    public static void setProperty(String key, Object value, boolean logAccess) {
        layers.peek().put(key, value);
        if (logAccess) {
            log.debug("Set option {} to {}.", key, value);
        }
        RuntimeStats.collect();
    }

    public static void clearProperty(String key, boolean logAccess) {
        layers.peek().remove(key);
        if (logAccess) {
            log.debug("Cleared option {}.", key);
        }
    }

    public static Object getProperty(String key, Object defaultValue, boolean logAccess) {
        Object value = null;
        for (Map<String, Object> layer : layers) {
            if (!layer.containsKey(key)) continue;
            value = layer.get(key);
            break;
        }
        if (logAccess) {
            if (value != null) {
                log.debug("Found value {} for option {}.", value, key);
            } else {
                log.debug("No value found for option {}. Returning default of {}.", key, defaultValue);
            }
        }
        return value == null ? defaultValue : value;
    }

    public static boolean hasProperty(String key) {
        return Config.getProperty(key, null, false) != null;
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        Object value = Config.getProperty(key, defaultValue, true);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return Boolean.valueOf(value.toString());
    }

    public static Double getDouble(String key, Number defaultValue) {
        Object value = Config.getProperty(key, defaultValue, true);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.valueOf(value.toString());
    }

    public static Float getFloat(String key, Number defaultValue) {
        Object value = Config.getProperty(key, defaultValue, true);
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            return Float.valueOf((String)value);
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return Float.valueOf(value.toString());
    }

    public static Integer getInteger(String key, Number defaultValue) {
        Object value = Config.getProperty(key, defaultValue, true);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(value.toString());
    }

    public static Long getLong(String key, Number defaultValue) {
        Object value = Config.getProperty(key, defaultValue, true);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.valueOf(value.toString());
    }

    public static String getString(String key, String defaultValue) {
        Object value = Config.getProperty(key, defaultValue, true);
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            return value.toString();
        }
        return (String)value;
    }

    public static List getList(String key, List defaultValue, boolean logAccess) {
        return (List)Config.getProperty(key, defaultValue, logAccess);
    }

    public static List<String> getStringList(String key) {
        List rawList = Config.getList(key, null, false);
        if (rawList == null) {
            return Collections.emptyList();
        }
        List rtn = rawList;
        return rtn;
    }

    public static Object getNewObject(String key, String defaultValue) {
        String className = Config.getString(key, defaultValue);
        if (className == null) {
            return null;
        }
        return Reflection.newObject(className);
    }

    static {
        Config.init();
    }
}

