/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.QueryAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.atom.UnmanagedObservedAtom;
import org.linqs.psl.model.atom.UnmanagedRandomVariableAtom;
import org.linqs.psl.model.predicate.FunctionalPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.util.IteratorUtils;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.Parallel;

public class AtomStore
implements Iterable<GroundAtom> {
    private static final Logger log = Logger.getLogger(AtomStore.class);
    public static final int MIN_ALLOCATION = 100;
    private Database database;
    private String threadKey;
    private int numAtoms;
    private float[] atomValues;
    private GroundAtom[] atoms;
    private int maxRVAIndex;
    private boolean storeAllAtoms;
    private Map<Atom, Integer> lookup;

    public AtomStore(Database database) {
        this.database = database;
        this.threadKey = this.getClass().getName();
        this.numAtoms = 0;
        this.atomValues = null;
        this.atoms = null;
        this.maxRVAIndex = -1;
        this.storeAllAtoms = false;
        this.lookup = null;
        this.init();
    }

    public int size() {
        return this.numAtoms;
    }

    public int getMaxRVAIndex() {
        return this.maxRVAIndex;
    }

    public float[] getAtomValues() {
        return this.atomValues;
    }

    public GroundAtom[] getAtoms() {
        return this.atoms;
    }

    public GroundAtom getAtom(int index) {
        return this.atoms[index];
    }

    public float getAtomValue(int index) {
        return this.atomValues[index];
    }

    public GroundAtom getAtom(Atom query) {
        Integer index = this.lookup.get(query);
        if (index != null) {
            return this.atoms[index];
        }
        Term[] queryArguments = query.getArguments();
        Constant[] arguments = new Constant[queryArguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            if (!(queryArguments[i] instanceof Constant)) {
                throw new RuntimeException("Attempted to get an atom using variables (instead of constants): " + query);
            }
            arguments[i] = (Constant)queryArguments[i];
        }
        GroundAtom atom = null;
        boolean storeAtom = false;
        if (query.getPredicate() instanceof FunctionalPredicate) {
            float value = ((FunctionalPredicate)query.getPredicate()).computeValue(this.database, arguments);
            atom = new UnmanagedObservedAtom(query.getPredicate(), arguments, value);
            storeAtom = true;
        } else {
            atom = this.database.isClosed(query.getPredicate()) ? new UnmanagedObservedAtom(query.getPredicate(), arguments, 0.0f) : new UnmanagedRandomVariableAtom((StandardPredicate)query.getPredicate(), arguments, 0.0f);
        }
        if (storeAtom || this.storeAllAtoms) {
            this.addAtom(atom);
        }
        return atom;
    }

    public GroundAtom getAtom(Predicate predicate, Constant ... args) {
        QueryAtom query = this.getQuery(predicate, args);
        GroundAtom atom = this.getAtom(query);
        this.releaseQuery(query);
        return atom;
    }

    public int getAtomIndex(Atom query) {
        Integer index = this.lookup.get(query);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public int getAtomIndex(Predicate predicate, Constant ... args) {
        QueryAtom query = this.getQuery(predicate, args);
        int index = this.getAtomIndex(query);
        this.releaseQuery(query);
        return index;
    }

    public boolean hasAtom(Atom query) {
        Integer index = this.lookup.get(query);
        return index != null;
    }

    public boolean hasAtom(Predicate predicate, Constant ... args) {
        QueryAtom query = this.getQuery(predicate, args);
        boolean result = this.hasAtom(query);
        this.releaseQuery(query);
        return result;
    }

    public double sync() {
        double movement = 0.0;
        for (int i = 0; i < this.numAtoms; ++i) {
            if (!(this.atoms[i] instanceof RandomVariableAtom)) continue;
            movement += Math.pow(this.atoms[i].getValue() - this.atomValues[i], 2.0);
            ((RandomVariableAtom)this.atoms[i]).setValue(this.atomValues[i]);
        }
        return Math.sqrt(movement);
    }

    public void resetValues() {
        for (int i = 0; i < this.numAtoms; ++i) {
            if (!(this.atoms[i] instanceof RandomVariableAtom)) continue;
            this.atomValues[i] = this.atoms[i].getValue();
        }
    }

    public void commit() {
        this.commit(false);
    }

    public void commit(boolean includeObs) {
        if (includeObs) {
            this.database.commit(this);
        } else {
            this.database.commit(this.getRandomVariableAtoms());
        }
    }

    @Override
    public Iterator<GroundAtom> iterator() {
        return Arrays.asList(this.atoms).subList(0, this.numAtoms).iterator();
    }

    public Iterable<RandomVariableAtom> getRandomVariableAtoms() {
        return IteratorUtils.filterClass(this, RandomVariableAtom.class);
    }

    public Iterable<RandomVariableAtom> getRandomVariableAtoms(final Predicate predicate) {
        return IteratorUtils.filter(IteratorUtils.filterClass(this, RandomVariableAtom.class), new IteratorUtils.FilterFunction<RandomVariableAtom>(){

            @Override
            public boolean keep(RandomVariableAtom atom) {
                return atom.getPredicate().equals(predicate);
            }
        });
    }

    public void addAtom(GroundAtom atom) {
        if (this.hasAtom(atom)) {
            GroundAtom otherAtom = this.getAtom(atom);
            if (atom.getPartition() == otherAtom.getPartition()) {
                return;
            }
            throw new IllegalStateException(String.format("Two identical atoms found in the same database. First Instance: (Atom: %s, Type: %s, Partition: %d), Second Instance: (Atom: %s, Type: %s, Partition: %d).", otherAtom, otherAtom.getClass(), otherAtom.getPartition(), atom, atom.getClass(), atom.getPartition()));
        }
        this.addAtomInternal(atom);
    }

    public synchronized void addAtomInternal(GroundAtom atom) {
        if (this.atoms.length == this.numAtoms) {
            this.reallocate();
        }
        atom.setIndex(this.numAtoms);
        this.atoms[this.numAtoms] = atom;
        this.atomValues[this.numAtoms] = atom.getValue();
        this.lookup.put(atom, this.numAtoms);
        if (atom instanceof RandomVariableAtom) {
            this.maxRVAIndex = this.numAtoms;
        }
        ++this.numAtoms;
    }

    public void close() {
        this.numAtoms = 0;
        this.atomValues = null;
        this.atoms = null;
        this.maxRVAIndex = -1;
        if (this.lookup != null) {
            this.lookup.clear();
            this.lookup = null;
        }
    }

    private QueryAtom getQuery(Predicate predicate, Constant ... args) {
        if (!Parallel.hasThreadObject(this.threadKey)) {
            Parallel.putThreadObject(this.threadKey, new ThreadResources(new QueryAtom(predicate, args)));
        }
        ThreadResources resources = (ThreadResources)Parallel.getThreadObject(this.threadKey);
        if (resources.queryInUse) {
            return new QueryAtom(predicate, args);
        }
        resources.query.assume(predicate, args);
        resources.queryInUse = true;
        return resources.query;
    }

    private void releaseQuery(QueryAtom query) {
        ThreadResources resources = (ThreadResources)Parallel.getThreadObject(this.threadKey);
        if (resources == null) {
            throw new RuntimeException("Attempt to release a query that has not been allocated (by getQuery()).");
        }
        resources.queryInUse = false;
    }

    private void init() {
        assert (this.numAtoms == 0);
        log.debug("Initializing AtomStore.");
        int databaseAtomCount = this.getDatabaseAtomCount();
        double overallocationFactor = Options.ATOM_STORE_OVERALLOCATION_FACTOR.getDouble();
        int allocationSize = (int)((double)Math.max(100, databaseAtomCount) * (1.0 + overallocationFactor));
        this.storeAllAtoms = Options.ATOM_STORE_STORE_ALL_ATOMS.getBoolean();
        this.atomValues = new float[allocationSize];
        this.atoms = new GroundAtom[this.atomValues.length];
        this.lookup = new HashMap<Atom, Integer>((int)((double)this.atomValues.length / 0.75));
        for (StandardPredicate predicate : this.database.getDataStore().getRegisteredPredicates()) {
            if (this.database.isClosed(predicate)) continue;
            for (GroundAtom atom : this.database.getAllGroundAtoms(predicate)) {
                this.addAtom(atom);
            }
        }
        for (StandardPredicate predicate : this.database.getDataStore().getRegisteredPredicates()) {
            if (!this.database.isClosed(predicate)) continue;
            for (GroundAtom atom : this.database.getAllGroundAtoms(predicate)) {
                this.addAtom(atom);
            }
        }
        log.debug("AtomStore Initialized.");
    }

    private synchronized void reallocate() {
        int newSize = this.atoms.length * 2;
        this.atomValues = Arrays.copyOf(this.atomValues, newSize);
        this.atoms = Arrays.copyOf(this.atoms, newSize);
    }

    private int getDatabaseAtomCount() {
        int count = 0;
        for (StandardPredicate predicate : this.database.getDataStore().getRegisteredPredicates()) {
            count += this.database.countAllGroundAtoms(predicate);
        }
        return count;
    }

    private static class ThreadResources {
        public QueryAtom query;
        public boolean queryInUse;

        public ThreadResources(QueryAtom query) {
            this.query = query;
            this.queryInUse = false;
        }
    }
}

