/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.formula.FormulaAnalysis;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.util.StringUtils;

public class DatabaseQuery {
    private final Formula formula;
    private final boolean distinct;
    private final Set<Variable> ignoreVariables;

    public DatabaseQuery(Formula formula) {
        this(formula, true);
    }

    public DatabaseQuery(Formula formula, boolean distinct) {
        this(formula, distinct, new HashSet<Variable>());
    }

    public DatabaseQuery(Formula formula, boolean distinct, Set<Variable> ignoreVariables) {
        this.formula = formula;
        this.distinct = distinct;
        this.ignoreVariables = ignoreVariables;
        DatabaseQuery.validate(formula);
    }

    public Formula getFormula() {
        return this.formula;
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public Set<Variable> getIgnoreVariables() {
        return this.ignoreVariables;
    }

    public static void validate(Formula formula) {
        FormulaAnalysis analysis = new FormulaAnalysis(formula);
        if (analysis.getNumDNFClauses() > 1 || analysis.getDNFClause(0).getNegLiterals().size() > 0) {
            throw new IllegalArgumentException("Illegal query formula. Must be a conjunction of atoms or a single atom. Formula: " + formula);
        }
        Set<Variable> unboundVariables = analysis.getDNFClause(0).getUnboundVariables();
        if (unboundVariables.size() > 0) {
            Object[] sortedVariables = unboundVariables.toArray(new Variable[unboundVariables.size()]);
            Arrays.sort(sortedVariables);
            throw new IllegalArgumentException("Any variable used in a negated (non-functional) predicate must also participate in a positive (non-functional) predicate. The following variables do not meet this requirement: [" + StringUtils.join(", ", sortedVariables) + "].");
        }
    }
}

