/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database;

import java.util.Collection;
import org.linqs.psl.config.Options;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.StringUtils;

public class PersistedAtomManagementException
extends RuntimeException {
    private static final Logger log = Logger.getLogger(PersistedAtomManagementException.class);
    private static boolean initialized = false;
    private static boolean throwOnIllegalAccess = false;
    private static boolean warnOnIllegalAccess = false;
    private Collection<GroundAtom> atoms;
    private Rule rule;

    private PersistedAtomManagementException(Collection<GroundAtom> atoms, Rule rule) {
        super(String.format("Found one or more RandomVariableAtoms (target ground atom) that were not explicitly specified in the targets. Offending atom(s): %s. This typically means that your specified target set is insufficient. This was encountered during the grounding of the rule: [%s].", StringUtils.join(", ", atoms), rule));
        PersistedAtomManagementException.init();
        this.atoms = atoms;
        this.rule = rule;
    }

    private static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        throwOnIllegalAccess = Options.PAM_THROW_ACCESS_EXCEPTION.getBoolean();
        warnOnIllegalAccess = !throwOnIllegalAccess;
    }

    public static void report(Collection<GroundAtom> atoms, Rule rule) {
        PersistedAtomManagementException exception = new PersistedAtomManagementException(atoms, rule);
        if (throwOnIllegalAccess) {
            throw exception;
        }
        if (warnOnIllegalAccess) {
            warnOnIllegalAccess = false;
            log.warn(String.format("Found non-persisted RVAs (%s). If you do not understand the implications of this warning, check your configuration and set '%s' to true. This warning will only be logged once.", StringUtils.join(", ", atoms), Options.PAM_THROW_ACCESS_EXCEPTION.name()));
        }
    }
}

