/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.DatabaseQuery;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.QueryResultIterable;
import org.linqs.psl.database.RawQuery;
import org.linqs.psl.database.ResultList;
import org.linqs.psl.database.rdbms.Formula2SQL;
import org.linqs.psl.database.rdbms.PredicateInfo;
import org.linqs.psl.database.rdbms.RDBMSDataStore;
import org.linqs.psl.database.rdbms.RDBMSResultList;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.model.term.DoubleAttribute;
import org.linqs.psl.model.term.IntegerAttribute;
import org.linqs.psl.model.term.LongAttribute;
import org.linqs.psl.model.term.StringAttribute;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.UniqueIntID;
import org.linqs.psl.model.term.UniqueStringID;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.model.term.VariableTypeMap;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.StringUtils;

public class RDBMSDatabase
extends Database {
    private static final Logger log = Logger.getLogger(RDBMSDatabase.class);
    private int fetchSize = Options.RDBMS_FETCH_SIZE.getInt();

    public RDBMSDatabase(RDBMSDataStore parent, Partition write, Partition[] read, Set<StandardPredicate> closed) {
        super(parent, write, read, closed);
        this.closed = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit(Iterable<? extends GroundAtom> atoms) {
        if (this.closed) {
            throw new IllegalStateException("Cannot commit on a closed database.");
        }
        HashMap atomsByPredicate = new HashMap();
        for (GroundAtom groundAtom : atoms) {
            if (!(groundAtom.getPredicate() instanceof StandardPredicate)) continue;
            if (!atomsByPredicate.containsKey(groundAtom.getPredicate())) {
                atomsByPredicate.put(groundAtom.getPredicate(), new ArrayList());
            }
            ((List)atomsByPredicate.get(groundAtom.getPredicate())).add(groundAtom);
        }
        try {
            Throwable throwable = null;
            try (Connection connection = this.getConnection();){
                for (Map.Entry entry : atomsByPredicate.entrySet()) {
                    try {
                        PreparedStatement statement = this.getAtomUpsert(connection, ((RDBMSDataStore)this.parentDataStore).getPredicateInfo((Predicate)entry.getKey()));
                        Throwable throwable2 = null;
                        try {
                            int batchSize = 0;
                            for (GroundAtom atom : (List)entry.getValue()) {
                                statement.setShort(1, atom.getPartition());
                                statement.setDouble(2, atom.getValue());
                                Constant[] arguments = atom.getArguments();
                                for (int i = 0; i < arguments.length; ++i) {
                                    this.setAtomArgument(statement, arguments[i], i + 3);
                                }
                                statement.addBatch();
                                if (++batchSize < 2500) continue;
                                statement.executeBatch();
                                statement.clearBatch();
                                batchSize = 0;
                            }
                            if (batchSize > 0) {
                                statement.executeBatch();
                                statement.clearBatch();
                            }
                            statement.clearParameters();
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (statement == null) continue;
                            if (throwable2 != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            statement.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException("Error doing batch commit for: " + entry.getKey(), ex);
                        return;
                    }
                }
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                throw throwable5;
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error doing batch commit.", ex);
        }
    }

    @Override
    public QueryResultIterable executeGroundingQuery(Formula formula) {
        return this.executeQueryIterator(formula, false);
    }

    @Override
    public ResultList executeQuery(DatabaseQuery query) {
        return this.executeQuery(query.getFormula(), query.getDistinct(), query.getIgnoreVariables());
    }

    @Override
    public QueryResultIterable executeQueryIterator(RawQuery rawQuery) {
        return this.executeQueryIterator(rawQuery.getProjectionMap(), rawQuery.getVariableTypes(), rawQuery.getSQL());
    }

    @Override
    public ResultList executeSQL(RawQuery rawQuery) {
        if (this.closed) {
            throw new IllegalStateException("Cannot perform query on database that was closed.");
        }
        Map<Variable, Integer> projectionMap = rawQuery.getProjectionMap();
        VariableTypeMap varTypes = rawQuery.getVariableTypes();
        String queryString = rawQuery.getSQL();
        int[] orderedIndexes = new int[projectionMap.size()];
        ConstantType[] orderedTypes = new ConstantType[projectionMap.size()];
        RDBMSResultList results = this.initQueryResults(projectionMap, varTypes, orderedIndexes, orderedTypes);
        for (Constant[] row : this.executeQueryIterator(queryString, projectionMap, orderedIndexes, orderedTypes)) {
            results.addResult(row);
        }
        log.trace("Number of results: {}", results.size());
        return results;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int countAllGroundAtoms(StandardPredicate predicate, List<Short> partitions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<GroundAtom> getAllGroundAtoms(StandardPredicate predicate, List<Short> partitions) {
        ArrayList<GroundAtom> atoms = new ArrayList<GroundAtom>();
        PredicateInfo predicateInfo = ((RDBMSDataStore)this.parentDataStore).getPredicateInfo(predicate);
        List<String> argumentCols = predicateInfo.argumentColumns();
        Constant[] arguments = new Constant[argumentCols.size()];
        try (Connection connection = this.getConnection();
             PreparedStatement statement = predicateInfo.createQueryAllStatement(connection, partitions);
             ResultSet results = statement.executeQuery();){
            while (results.next()) {
                for (int i = 0; i < argumentCols.size(); ++i) {
                    arguments[i] = this.extractConstantFromResult(results, i + 2, predicate.getArgumentType(i));
                }
                atoms.add(this.extractGroundAtomFromResult(results, predicate, arguments));
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error fetching all ground atoms for: " + predicate, ex);
        }
        return atoms;
    }

    private ResultList executeQuery(Formula formula, boolean isDistinct, Set<Variable> ignoreVariables) {
        VariableTypeMap varTypes = formula.collectVariables(new VariableTypeMap());
        HashSet<Variable> projectTo = new HashSet<Variable>(varTypes.getVariables());
        projectTo.removeAll(ignoreVariables);
        Formula2SQL sqler = new Formula2SQL(projectTo, this, isDistinct);
        String queryString = sqler.getSQL(formula);
        Map<Variable, Integer> projectionMap = sqler.getProjectionMap();
        return this.executeQuery(projectionMap, varTypes, queryString);
    }

    private ResultList executeQuery(Map<Variable, Integer> projectionMap, VariableTypeMap varTypes, String queryString) {
        if (this.closed) {
            throw new IllegalStateException("Cannot perform query on database that was closed.");
        }
        int[] orderedIndexes = new int[projectionMap.size()];
        ConstantType[] orderedTypes = new ConstantType[projectionMap.size()];
        RDBMSResultList results = this.initQueryResults(projectionMap, varTypes, orderedIndexes, orderedTypes);
        for (Constant[] row : this.executeQueryIterator(queryString, projectionMap, orderedIndexes, orderedTypes)) {
            results.addResult(row);
        }
        return results;
    }

    private QueryResultIterable executeQueryIterator(Formula formula, boolean isDistinct) {
        VariableTypeMap varTypes = formula.collectVariables(new VariableTypeMap());
        HashSet<Variable> projectTo = new HashSet<Variable>(varTypes.getVariables());
        Formula2SQL sqler = new Formula2SQL(projectTo, this, isDistinct);
        String queryString = sqler.getSQL(formula);
        Map<Variable, Integer> projectionMap = sqler.getProjectionMap();
        return this.executeQueryIterator(projectionMap, varTypes, queryString);
    }

    private QueryResultIterable executeQueryIterator(Map<Variable, Integer> projectionMap, VariableTypeMap varTypes, String queryString) {
        if (this.closed) {
            throw new IllegalStateException("Cannot perform query on database that was closed.");
        }
        int[] orderedIndexes = new int[projectionMap.size()];
        ConstantType[] orderedTypes = new ConstantType[projectionMap.size()];
        this.initQueryResults(projectionMap, varTypes, orderedIndexes, orderedTypes);
        return this.executeQueryIterator(queryString, projectionMap, orderedIndexes, orderedTypes);
    }

    private QueryResultIterable executeQueryIterator(String queryString, Map<Variable, Integer> projectionMap, int[] orderedIndexes, ConstantType[] orderedTypes) {
        if (this.closed) {
            throw new IllegalStateException("Cannot perform query on database that was closed.");
        }
        log.trace(queryString);
        return new RDBMSQueryResultIterable(queryString, projectionMap, orderedIndexes, orderedTypes);
    }

    private Constant extractConstantFromResult(ResultSet results, int columnIndex, ConstantType type) {
        try {
            switch (type) {
                case Double: {
                    return new DoubleAttribute(results.getDouble(columnIndex + 1));
                }
                case Integer: {
                    return new IntegerAttribute(results.getInt(columnIndex + 1));
                }
                case String: {
                    return new StringAttribute(results.getString(columnIndex + 1));
                }
                case Long: {
                    return new LongAttribute(results.getLong(columnIndex + 1));
                }
                case UniqueIntID: {
                    return new UniqueIntID(results.getInt(columnIndex + 1));
                }
                case UniqueStringID: {
                    return new UniqueStringID(results.getString(columnIndex + 1));
                }
            }
            throw new IllegalArgumentException("Unknown argument type: " + (Object)((Object)type));
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error extracting constant from ResultSet.", ex);
        }
    }

    private GroundAtom extractGroundAtomFromResult(ResultSet resultSet, StandardPredicate predicate, Constant[] arguments) throws SQLException {
        float value = resultSet.getFloat("truth_value");
        if (resultSet.wasNull()) {
            value = Float.NaN;
        } else if (value < 0.0f || value > 1.0f) {
            throw new IllegalArgumentException(String.format("Attempt to instantiate an atom with a truth value outside of [0, 1]. Value: %f, Predicate: %s, Arguments: [%s].", Float.valueOf(value), predicate, StringUtils.join(", ", (Object[])arguments)));
        }
        short partition = resultSet.getShort("partition_id");
        if (partition == this.writeID) {
            if (this.isClosed(predicate)) {
                return new ObservedAtom(predicate, arguments, value, partition);
            }
            return new RandomVariableAtom(predicate, arguments, value, partition);
        }
        return new ObservedAtom(predicate, arguments, value, partition);
    }

    private PreparedStatement getAtomUpsert(Connection connection, PredicateInfo predicate) {
        return predicate.createUpsertStatement(connection, ((RDBMSDataStore)this.parentDataStore).getDriver());
    }

    private Connection getConnection() {
        return ((RDBMSDataStore)this.parentDataStore).getConnection();
    }

    private RDBMSResultList initQueryResults(Map<Variable, Integer> projectionMap, VariableTypeMap varTypes, int[] orderedIndexes, ConstantType[] orderedTypes) {
        RDBMSResultList results = new RDBMSResultList(projectionMap.size());
        for (Map.Entry<Variable, Integer> projection : projectionMap.entrySet()) {
            results.setVariable(projection.getKey(), projection.getValue());
        }
        for (Map.Entry<Variable, Integer> entry : results.getVariableMap().entrySet()) {
            Variable variable = entry.getKey();
            int index = entry.getValue();
            orderedIndexes[index] = projectionMap.get(variable);
            orderedTypes[index] = varTypes.getType(variable);
        }
        return results;
    }

    private void setAtomArgument(PreparedStatement statement, Term argument, int index) throws SQLException {
        if (argument instanceof IntegerAttribute) {
            statement.setInt(index, ((IntegerAttribute)argument).getValue());
        } else if (argument instanceof DoubleAttribute) {
            statement.setDouble(index, ((DoubleAttribute)argument).getValue());
        } else if (argument instanceof StringAttribute) {
            statement.setString(index, ((StringAttribute)argument).getValue());
        } else if (argument instanceof LongAttribute) {
            statement.setLong(index, ((LongAttribute)argument).getValue());
        } else if (argument instanceof UniqueIntID) {
            statement.setInt(index, ((UniqueIntID)argument).getID());
        } else if (argument instanceof UniqueStringID) {
            statement.setString(index, ((UniqueStringID)argument).getID());
        } else {
            throw new IllegalArgumentException("Unknown argument type: " + argument.getClass());
        }
    }

    private class RDBMSQueryResultIterator
    implements Iterator<Constant[]>,
    AutoCloseable {
        private String queryString;
        private int[] orderedIndexes;
        private ConstantType[] orderedTypes;
        private Connection connection;
        private Statement statement;
        private ResultSet resultSet;
        private Constant[] next;
        private Queue<Constant[]> reusePool;

        public RDBMSQueryResultIterator(String queryString, int[] orderedIndexes, ConstantType[] orderedTypes) {
            this.queryString = queryString;
            this.orderedIndexes = orderedIndexes;
            this.orderedTypes = orderedTypes;
            this.reusePool = new ConcurrentLinkedQueue<Constant[]>();
            this.next = null;
            this.connection = null;
            this.statement = null;
            this.resultSet = null;
            try {
                this.connection = RDBMSDatabase.this.getConnection();
                this.connection.setAutoCommit(false);
                this.statement = this.connection.createStatement();
                this.statement.setFetchSize(RDBMSDatabase.this.fetchSize);
                this.resultSet = this.statement.executeQuery(queryString);
            }
            catch (SQLException ex) {
                this.close();
                throw new RuntimeException("Error executing query: [" + queryString + "],", ex);
            }
            this.fetchNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Constant[] next() {
            Constant[] rtn = this.next;
            this.fetchNext();
            return rtn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void reuse(Collection<Constant[]> reuseConstants) {
            if (this.reusePool != null) {
                this.reusePool.addAll(reuseConstants);
            }
        }

        private void fetchNext() {
            boolean hasNext = false;
            try {
                hasNext = this.resultSet.next();
            }
            catch (SQLException ex) {
                throw new RuntimeException("Error while fetching results for query: [" + this.queryString + "].", ex);
            }
            if (hasNext) {
                this.next = this.reusePool.poll();
                if (this.next == null) {
                    this.next = new Constant[this.orderedIndexes.length];
                }
                for (int i = 0; i < this.next.length; ++i) {
                    this.next[i] = RDBMSDatabase.this.extractConstantFromResult(this.resultSet, this.orderedIndexes[i], this.orderedTypes[i]);
                }
            } else {
                this.close();
            }
        }

        @Override
        public void close() {
            this.next = null;
            if (this.resultSet != null) {
                try {
                    this.resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.resultSet = null;
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.statement = null;
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = null;
            }
            if (this.reusePool != null) {
                this.reusePool.clear();
                this.reusePool = null;
            }
        }
    }

    private class RDBMSQueryResultIterable
    implements QueryResultIterable {
        private Map<Variable, Integer> projectionMap;
        private RDBMSQueryResultIterator iterator;

        public RDBMSQueryResultIterable(String queryString, Map<Variable, Integer> projectionMap, int[] orderedIndexes, ConstantType[] orderedTypes) {
            this.projectionMap = Collections.unmodifiableMap(projectionMap);
            this.iterator = new RDBMSQueryResultIterator(queryString, orderedIndexes, orderedTypes);
        }

        @Override
        public void reuse(Collection<Constant[]> reuseConstants) {
            this.iterator.reuse(reuseConstants);
        }

        @Override
        public Map<Variable, Integer> getVariableMap() {
            return this.projectionMap;
        }

        @Override
        public Iterator<Constant[]> iterator() {
            return this.iterator;
        }

        @Override
        public void close() {
            if (this.iterator != null) {
                this.iterator.close();
                this.iterator = null;
            }
        }
    }
}

