/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.grounding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.QueryResultIterable;
import org.linqs.psl.grounding.collective.CandidateGeneration;
import org.linqs.psl.grounding.collective.CandidateQuery;
import org.linqs.psl.grounding.collective.Coverage;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.Parallel;

public class Grounding {
    private static final Logger log = Logger.getLogger(Grounding.class);
    private static GroundRuleCallback groundRuleCallback = null;

    private Grounding() {
    }

    public static void setGroundRuleCallback(GroundRuleCallback groundRuleCallback) {
        Grounding.groundRuleCallback = groundRuleCallback;
    }

    public static long groundAll(List<Rule> rules, TermStore termStore) {
        boolean collective = Options.GROUNDING_COLLECTIVE.getBoolean();
        if (collective) {
            return Grounding.groundCollective(rules, termStore);
        }
        return Grounding.groundIndependent(rules, termStore);
    }

    private static long groundIndependent(List<Rule> rules, TermStore termStore) {
        long termCount = 0L;
        for (Rule rule : rules) {
            termCount += rule.groundAll(termStore, groundRuleCallback);
        }
        return termCount;
    }

    private static long groundCollective(List<Rule> rules, TermStore termStore) {
        ArrayList<Rule> bypassRules = new ArrayList<Rule>();
        ArrayList<Rule> collectiveRules = new ArrayList<Rule>(rules.size());
        for (Rule rule : rules) {
            if (rule.supportsGroundingQueryRewriting()) {
                collectiveRules.add(rule);
                continue;
            }
            bypassRules.add(rule);
        }
        Set<CandidateQuery> candidates = Grounding.genCandidates(collectiveRules, termStore.getDatabase());
        Set<CandidateQuery> coverage = Coverage.compute(collectiveRules, candidates);
        long initialSize = termStore.size();
        Grounding.groundIndependent(bypassRules, termStore);
        int batchSize = Options.GROUNDING_COLLECTIVE_BATCH_SIZE.getInt();
        for (CandidateQuery candidate : coverage) {
            HashSet<Rule> toGround = new HashSet<Rule>(collectiveRules);
            toGround.retainAll(candidate.getCoveredRules());
            Grounding.sharedGrounding(candidate, toGround, termStore, batchSize);
            collectiveRules.removeAll(candidate.getCoveredRules());
        }
        return termStore.size() - initialSize;
    }

    private static Set<CandidateQuery> genCandidates(List<Rule> collectiveRules, Database database) {
        Set<CandidateQuery> candidates = Collections.synchronizedSet(new HashSet());
        if (!database.getDataStore().canExplain()) {
            log.warn("Cannot generate query candidates without EXPLAIN capabilities, grounding will be suboptimal.");
            for (Rule rule : collectiveRules) {
                candidates.add(new CandidateQuery(rule, rule.getRewritableGroundingFormula(), 0.0));
            }
            return candidates;
        }
        final CandidateGeneration candidateGeneration = new CandidateGeneration();
        final int candiatesPerRule = Options.GROUNDING_COLLECTIVE_CANDIDATE_COUNT.getInt();
        final Database finalDatabase = database;
        final Set<CandidateQuery> finalCandidates = candidates;
        log.debug("Generating candidates.");
        Parallel.RunTimings timings = Parallel.foreach(collectiveRules, new Parallel.Worker<Rule>(){

            @Override
            public void work(long index, Rule rule) {
                candidateGeneration.generateCandidates(rule, finalDatabase, candiatesPerRule, finalCandidates);
            }
        });
        log.debug("Generated {} candidates", candidates.size());
        log.trace("    " + timings);
        return candidates;
    }

    private static long sharedGrounding(CandidateQuery candidate, Set<Rule> rules, TermStore termStore, int batchSize) {
        log.debug("Grounding {} rule(s) with query: [{}].", rules.size(), candidate.getFormula());
        for (Rule rule : rules) {
            log.trace("    " + rule);
        }
        Parallel.RunTimings timings = null;
        long termCount = -1L;
        try (QueryResultIterable queryResults = termStore.getDatabase().executeGroundingQuery(candidate.getFormula());){
            HashMap<Rule, Map<Variable, Integer>> variableMaps = new HashMap<Rule, Map<Variable, Integer>>();
            Map<Variable, Integer> baseVariableMap = queryResults.getVariableMap();
            for (Rule rule : rules) {
                if (rule == candidate.getBaseRule()) {
                    variableMaps.put(rule, baseVariableMap);
                    continue;
                }
                HashMap<Variable, Integer> variableMap = new HashMap<Variable, Integer>();
                Map<Variable, Variable> containmentMapping = candidate.getVariableMapping(rule);
                for (Map.Entry<Variable, Integer> baseVariabelMapEntry : baseVariableMap.entrySet()) {
                    variableMap.put(containmentMapping.get(baseVariabelMapEntry.getKey()), baseVariabelMapEntry.getValue());
                }
                variableMaps.put(rule, variableMap);
            }
            long initialCount = termStore.size();
            timings = Parallel.foreachBatch(queryResults, batchSize, new GroundWorker(termStore, variableMaps, rules));
            termCount = termStore.size() - initialCount;
        }
        log.debug("Generated {} terms from {} query results.", termCount, timings.iterations);
        log.trace("   " + timings);
        return termCount;
    }

    public static interface GroundRuleCallback {
        public void call(GroundRule var1);
    }

    private static class GroundWorker
    extends Parallel.Worker<List<Constant[]>> {
        private TermStore termStore;
        private Map<Rule, Map<Variable, Integer>> variableMaps;
        private Set<Rule> rules;
        private List<GroundRule> groundRules;

        public GroundWorker(TermStore termStore, Map<Rule, Map<Variable, Integer>> variableMaps, Set<Rule> rules) {
            this.termStore = termStore;
            this.variableMaps = variableMaps;
            this.rules = rules;
            this.groundRules = new ArrayList<GroundRule>();
        }

        public Object clone() {
            return new GroundWorker(this.termStore, this.variableMaps, this.rules);
        }

        @Override
        public void work(long size, List<Constant[]> batch) {
            GroundRule groundRule = null;
            for (Rule rule : this.rules) {
                int rowIndex = 0;
                while ((long)rowIndex < size) {
                    rule.ground(batch.get(rowIndex), this.variableMaps.get(rule), this.termStore.getDatabase(), this.groundRules);
                    for (int groundRuleIndex = 0; groundRuleIndex < this.groundRules.size(); ++groundRuleIndex) {
                        groundRule = this.groundRules.get(groundRuleIndex);
                        if (groundRule == null) continue;
                        this.termStore.add(groundRule);
                        if (groundRuleCallback == null) continue;
                        groundRuleCallback.call(groundRule);
                    }
                    this.groundRules.clear();
                    ++rowIndex;
                }
            }
            ((QueryResultIterable)this.source).reuse(batch);
        }
    }
}

