/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.grounding.collective;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.linqs.psl.grounding.collective.CandidateQuery;
import org.linqs.psl.grounding.collective.Containment;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coverage {
    private static final Logger log = LoggerFactory.getLogger(Coverage.class);

    private Coverage() {
    }

    public static Set<CandidateQuery> compute(List<Rule> collectiveRules, Set<CandidateQuery> candidates) {
        Containment.computeContainement(collectiveRules, candidates);
        Set<CandidateQuery> coverage = Coverage.greedySmartCoverage(collectiveRules, candidates);
        if (coverage != null) {
            return coverage;
        }
        throw new IllegalStateException(String.format("Could not compute coverage. Collective Rules: %s, Candidates: %s.", collectiveRules, candidates));
    }

    private static Set<CandidateQuery> greedySmartCoverage(List<Rule> collectiveRules, Set<CandidateQuery> candidates) {
        HashSet<CandidateQuery> coverage = new HashSet<CandidateQuery>();
        HashSet<Rule> coveredRules = new HashSet<Rule>();
        HashMap<Rule, Double> bestRuleScores = new HashMap<Rule, Double>();
        for (CandidateQuery candidate : candidates) {
            for (Rule rule : candidate.getCoveredRules()) {
                if (bestRuleScores.containsKey(rule) && !(candidate.getScore() < (Double)bestRuleScores.get(rule))) continue;
                bestRuleScores.put(rule, candidate.getScore());
            }
        }
        double lowestScore = 0.0;
        CandidateQuery bestCandidate = null;
        while (coveredRules.size() != collectiveRules.size()) {
            lowestScore = 0.0;
            bestCandidate = null;
            for (CandidateQuery candidate : candidates) {
                if (coverage.contains(candidate)) continue;
                double score = candidate.getScore();
                boolean hasUncoveredRule = false;
                for (Rule rule : candidate.getCoveredRules()) {
                    if (coveredRules.contains(rule)) continue;
                    score -= ((Double)bestRuleScores.get(rule)).doubleValue();
                    hasUncoveredRule = true;
                }
                if (!hasUncoveredRule || bestCandidate != null && !(score < lowestScore)) continue;
                lowestScore = score;
                bestCandidate = candidate;
            }
            coverage.add(bestCandidate);
            coveredRules.addAll(bestCandidate.getCoveredRules());
            if (coveredRules.size() != collectiveRules.size()) continue;
            return coverage;
        }
        return null;
    }

    private static Set<CandidateQuery> greedyNaiveCoverage(List<Rule> collectiveRules, Set<CandidateQuery> candidates) {
        ArrayList<CandidateQuery> orderedCandidates = new ArrayList<CandidateQuery>(candidates);
        Collections.sort(orderedCandidates, new Comparator<CandidateQuery>(){

            @Override
            public int compare(CandidateQuery a, CandidateQuery b) {
                return MathUtils.compare(a.getScore(), b.getScore());
            }
        });
        HashSet<CandidateQuery> coverage = new HashSet<CandidateQuery>();
        HashSet<Rule> coveredRules = new HashSet<Rule>();
        for (CandidateQuery candidate : orderedCandidates) {
            if (coveredRules.containsAll(candidate.getCoveredRules())) continue;
            coverage.add(candidate);
            coveredRules.addAll(candidate.getCoveredRules());
            if (coveredRules.size() != collectiveRules.size()) continue;
            return coverage;
        }
        return null;
    }
}

