/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.atom;

import java.util.Map;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.ResultList;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.predicate.FunctionalPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.model.term.VariableTypeMap;
import org.linqs.psl.util.MathUtils;

public class QueryAtom
extends Atom {
    public QueryAtom(Predicate predicate, Term ... args) {
        super(predicate, args);
    }

    public void assume(Predicate predicate, Term ... args) {
        this.init(false, false, predicate, args);
    }

    public GroundAtom ground(Database database, ResultList res, int resultIndex) {
        return this.ground(database, res, resultIndex, new Constant[this.arguments.length], -1.0f);
    }

    public GroundAtom ground(Database database, ResultList res, int resultIndex, Constant[] newArgs, float trivialValue) {
        return this.ground(database, res, resultIndex, newArgs, trivialValue, false);
    }

    public GroundAtom ground(Database database, ResultList res, int resultIndex, Constant[] newArgs, float trivialValue, boolean ignoreUnmanagedAtoms) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] instanceof Variable) {
                newArgs[i] = res.get(resultIndex, (Variable)this.arguments[i]);
                continue;
            }
            if (this.arguments[i] instanceof Constant) {
                newArgs[i] = (Constant)this.arguments[i];
                continue;
            }
            throw new IllegalArgumentException("Unrecognized type of Term.");
        }
        return this.fetchAtom(database, this.predicate, newArgs, trivialValue, ignoreUnmanagedAtoms);
    }

    public GroundAtom ground(Database database, Constant[] queryResults, Map<Variable, Integer> projectionMap) {
        return this.ground(database, queryResults, projectionMap, new Constant[this.arguments.length], -1.0f);
    }

    public GroundAtom ground(Database database, Constant[] queryResults, Map<Variable, Integer> projectionMap, Constant[] newArgs, float trivialValue) {
        return this.ground(database, queryResults, projectionMap, newArgs, trivialValue, false);
    }

    public GroundAtom ground(Database database, Constant[] queryResults, Map<Variable, Integer> projectionMap, Constant[] newArgs, float trivialValue, boolean ignoreUnmanagedAtoms) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] instanceof Variable) {
                newArgs[i] = queryResults[projectionMap.get((Variable)this.arguments[i])];
                continue;
            }
            if (this.arguments[i] instanceof Constant) {
                newArgs[i] = (Constant)this.arguments[i];
                continue;
            }
            throw new IllegalArgumentException("Unrecognized type of Term.");
        }
        return this.fetchAtom(database, this.predicate, newArgs, trivialValue, ignoreUnmanagedAtoms);
    }

    @Override
    public VariableTypeMap collectVariables(VariableTypeMap varMap) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (!(this.arguments[i] instanceof Variable)) continue;
            ConstantType t = this.predicate.getArgumentType(i);
            varMap.addVariable((Variable)this.arguments[i], t);
        }
        return varMap;
    }

    private GroundAtom fetchAtom(Database database, Predicate predicate, Constant[] args, float trivialValue, boolean ignoreUnmanagedAtoms) {
        GroundAtom atom = database.getAtomStore().getAtom(predicate, args);
        if (predicate instanceof FunctionalPredicate) {
            return atom;
        }
        if (ignoreUnmanagedAtoms && !atom.isManaged()) {
            return null;
        }
        if (atom instanceof ObservedAtom && MathUtils.equals(trivialValue, atom.getValue())) {
            return null;
        }
        return atom;
    }
}

