/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.duallcqp.term;

import org.linqs.psl.reasoner.duallcqp.term.DualLCQPObjectiveTerm;
import org.linqs.psl.reasoner.term.TermState;
import org.linqs.psl.util.MathUtils;

public final class DualLCQPAtom {
    private double message = 0.0;
    private double lowerBoundDualVariable = 0.0;
    private double upperBoundDualVariable = 0.0;

    public void addTerm(DualLCQPObjectiveTerm term, float coefficient) {
        this.addToMessage(term.getDualVariable() * (double)coefficient);
    }

    public synchronized void update(double termDualDelta, double coefficient, double regularizationParameter, double stepSize) {
        double lowerBoundPartial = this.getLowerBoundPartial(regularizationParameter);
        double upperBoundPartial = this.getUpperBoundPartial(regularizationParameter);
        this.addToMessage(termDualDelta * coefficient);
        this.setLowerBoundDualVariable(Math.max(0.0, this.lowerBoundDualVariable - stepSize * lowerBoundPartial));
        this.setUpperBoundDualVariable(Math.max(0.0, this.upperBoundDualVariable - stepSize * upperBoundPartial));
    }

    private synchronized void addToMessage(double value) {
        this.message += value;
    }

    public double getMessage() {
        return this.message;
    }

    public float getPrimal(double regularizationParameter) {
        return (float)(-1.0 * this.message / (2.0 * regularizationParameter));
    }

    public double getLowerBoundDualVariable() {
        return this.lowerBoundDualVariable;
    }

    public double getUpperBoundDualVariable() {
        return this.upperBoundDualVariable;
    }

    public synchronized void setLowerBoundDualVariable(double lowerBoundDualVariable) {
        double dualVariableChange = lowerBoundDualVariable - this.lowerBoundDualVariable;
        this.addToMessage(-1.0 * dualVariableChange);
        this.lowerBoundDualVariable = lowerBoundDualVariable;
    }

    public synchronized void setUpperBoundDualVariable(double upperBoundDualVariable) {
        double dualVariableChange = upperBoundDualVariable - this.upperBoundDualVariable;
        this.addToMessage(dualVariableChange);
        this.upperBoundDualVariable = upperBoundDualVariable;
    }

    public double getLowerBoundObjective(double regularizationParameter) {
        return -1.0 * this.message * this.lowerBoundDualVariable / (2.0 * regularizationParameter);
    }

    public double getUpperBoundObjective(double regularizationParameter) {
        return this.message * this.upperBoundDualVariable / (2.0 * regularizationParameter) + 2.0 * this.upperBoundDualVariable;
    }

    public double getLowerBoundPartial(double regularizationParameter) {
        double lowerBoundPartial = -1.0 * this.message / regularizationParameter;
        if (MathUtils.isZero(this.lowerBoundDualVariable, 1.0E-8) && lowerBoundPartial > 0.0) {
            lowerBoundPartial = 0.0;
        }
        return lowerBoundPartial;
    }

    public double getUpperBoundPartial(double regularizationParameter) {
        double upperBoundPartial = this.message / regularizationParameter + 2.0;
        if (MathUtils.isZero(this.upperBoundDualVariable, 1.0E-8) && upperBoundPartial > 0.0) {
            upperBoundPartial = 0.0;
        }
        return upperBoundPartial;
    }

    public synchronized void loadState(TermState termState) {
        assert (termState instanceof DualLCQPAtomState);
        DualLCQPAtomState dualLCQPAtomState = (DualLCQPAtomState)termState;
        this.message = dualLCQPAtomState.message;
        this.lowerBoundDualVariable = dualLCQPAtomState.lowerBoundDualVariable;
        this.upperBoundDualVariable = dualLCQPAtomState.upperBoundDualVariable;
    }

    public TermState saveState() {
        return new DualLCQPAtomState(this.message, this.lowerBoundDualVariable, this.upperBoundDualVariable);
    }

    public void saveState(TermState termState) {
        assert (termState instanceof DualLCQPAtomState);
        DualLCQPAtomState dualLCQPAtomState = (DualLCQPAtomState)termState;
        dualLCQPAtomState.message = this.message;
        dualLCQPAtomState.lowerBoundDualVariable = this.lowerBoundDualVariable;
        dualLCQPAtomState.upperBoundDualVariable = this.upperBoundDualVariable;
    }

    public static final class DualLCQPAtomState
    extends TermState {
        public double message;
        public double lowerBoundDualVariable;
        public double upperBoundDualVariable;

        public DualLCQPAtomState(double message, double lowerBoundDualVariable, double upperBoundDualVariable) {
            this.message = message;
            this.lowerBoundDualVariable = lowerBoundDualVariable;
            this.upperBoundDualVariable = upperBoundDualVariable;
        }
    }
}

