/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.duallcqp.term;

import org.linqs.psl.config.Options;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.TermState;

public class DualLCQPObjectiveTerm
extends ReasonerTerm {
    protected static final double regularizationParameter = Options.DUAL_LCQP_REGULARIZATION.getDouble();
    protected double dualVariable = 0.0;
    protected double slackBoundDualVariable = 0.0;
    protected boolean isEqualityConstraint;

    public DualLCQPObjectiveTerm(Hyperplane hyperplane, Rule rule, boolean squared, boolean hinge, FunctionComparator comparator) {
        super(hyperplane, rule, squared, hinge, comparator);
        boolean bl = this.isEqualityConstraint = this.comparator != null && this.comparator.equals((Object)FunctionComparator.EQ);
        if (this.comparator != null && this.comparator.equals((Object)FunctionComparator.GTE)) {
            this.comparator = FunctionComparator.LTE;
            for (int i = 0; i < this.size; ++i) {
                this.coefficients[i] = -this.coefficients[i];
            }
            this.constant = -this.constant;
        }
    }

    @Override
    public float evaluate(float[] variableValues) {
        float incompatibility = this.evaluateIncompatibility(variableValues);
        if (this.isConstraint()) {
            if (incompatibility > 0.0f) {
                return Float.POSITIVE_INFINITY;
            }
            return 0.0f;
        }
        return (float)((double)(this.getWeight() * incompatibility) + regularizationParameter * (double)this.evaluateSquaredHingeLoss(variableValues));
    }

    @Override
    public float computeVariablePartial(int varId, float innerPotential) {
        float unregularizedPartial = super.computeVariablePartial(varId, innerPotential);
        if (this.isConstraint()) {
            return unregularizedPartial;
        }
        return (float)((double)unregularizedPartial + regularizationParameter * (double)this.computeSquaredHingeLossPartial(varId, innerPotential));
    }

    public boolean isEqualityConstraint() {
        return this.isEqualityConstraint;
    }

    public double getDualVariable() {
        return this.dualVariable;
    }

    public void setDualVariable(double dualVariable) {
        this.dualVariable = dualVariable;
    }

    public double getSlackBoundDualVariable() {
        assert (!this.isConstraint());
        return this.slackBoundDualVariable;
    }

    public void setSlackBoundDualVariable(double slackBoundDualVariable) {
        assert (!this.isConstraint());
        this.slackBoundDualVariable = slackBoundDualVariable;
    }

    public double computeSelfInnerProduct() {
        double innerProduct = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            innerProduct += (double)(this.coefficients[i] * this.coefficients[i]);
        }
        return innerProduct;
    }

    @Override
    public void loadState(TermState termState) {
        assert (termState instanceof DualLCQPObjectiveTermState);
        DualLCQPObjectiveTermState objectiveTermState = (DualLCQPObjectiveTermState)termState;
        this.dualVariable = objectiveTermState.dualVariable;
        this.slackBoundDualVariable = objectiveTermState.slackBoundDualVariable;
    }

    @Override
    public TermState saveState() {
        return new DualLCQPObjectiveTermState(this.dualVariable, this.slackBoundDualVariable);
    }

    @Override
    public void saveState(TermState termState) {
        assert (termState instanceof DualLCQPObjectiveTermState);
        DualLCQPObjectiveTermState objectiveTermState = (DualLCQPObjectiveTermState)termState;
        objectiveTermState.dualVariable = this.dualVariable;
        objectiveTermState.slackBoundDualVariable = this.slackBoundDualVariable;
    }

    public static final class DualLCQPObjectiveTermState
    extends TermState {
        public double dualVariable;
        public double slackBoundDualVariable;

        public DualLCQPObjectiveTermState(double dualVariable, double slackBoundDualVariable) {
            this.dualVariable = dualVariable;
            this.slackBoundDualVariable = slackBoundDualVariable;
        }
    }
}

