/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.duallcqp.term;

import org.linqs.psl.database.AtomStore;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.duallcqp.term.DualLCQPAtom;
import org.linqs.psl.reasoner.duallcqp.term.DualLCQPObjectiveTerm;
import org.linqs.psl.reasoner.duallcqp.term.DualLCQPTermGenerator;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.SimpleTermStore;
import org.linqs.psl.reasoner.term.TermState;

public class DualLCQPTermStore
extends SimpleTermStore<DualLCQPObjectiveTerm> {
    protected DualLCQPAtom[] dualLCQPAtoms = new DualLCQPAtom[100];

    public DualLCQPTermStore(Database database) {
        super(database, new DualLCQPTermGenerator());
        for (int i = 0; i < this.dualLCQPAtoms.length; ++i) {
            this.dualLCQPAtoms[i] = new DualLCQPAtom();
        }
    }

    public synchronized void init() {
        if (this.dualLCQPAtoms == null) {
            AtomStore atomStore = this.database.getAtomStore();
            this.dualLCQPAtoms = new DualLCQPAtom[atomStore.size()];
            for (int i = 0; i < this.dualLCQPAtoms.length; ++i) {
                this.dualLCQPAtoms[i] = new DualLCQPAtom();
            }
        }
    }

    @Override
    public void initForOptimization() {
        super.initForOptimization();
        this.init();
    }

    @Override
    public synchronized int add(GroundRule groundRule, DualLCQPObjectiveTerm term, Hyperplane hyperplane) {
        this.ensureDualLCQPAtomsCapacity();
        super.add(groundRule, term, hyperplane);
        int[] atomIndexes = term.getAtomIndexes();
        float[] coefficients = term.getCoefficients();
        for (int i = 0; i < term.size(); ++i) {
            this.dualLCQPAtoms[atomIndexes[i]].addTerm(term, coefficients[i]);
        }
        return 1;
    }

    public DualLCQPAtom getDualLCQPAtom(int index) {
        return this.dualLCQPAtoms[index];
    }

    public DualLCQPAtom[] getDualLCQPAtoms() {
        return this.dualLCQPAtoms;
    }

    private synchronized void ensureDualLCQPAtomsCapacity() {
        if (this.dualLCQPAtoms.length < this.database.getAtomStore().size()) {
            DualLCQPAtom[] newDualLCQPAtoms = new DualLCQPAtom[this.database.getAtomStore().size()];
            System.arraycopy(this.dualLCQPAtoms, 0, newDualLCQPAtoms, 0, this.dualLCQPAtoms.length);
            for (int i = this.dualLCQPAtoms.length; i < newDualLCQPAtoms.length; ++i) {
                newDualLCQPAtoms[i] = new DualLCQPAtom();
            }
            this.dualLCQPAtoms = newDualLCQPAtoms;
        }
    }

    @Override
    public void loadState(TermState[] termStates) {
        int i = 0;
        while ((long)i < this.size()) {
            ((DualLCQPObjectiveTerm)this.get(i)).loadState(termStates[i]);
            ++i;
        }
        for (i = 0; i < this.dualLCQPAtoms.length; ++i) {
            this.dualLCQPAtoms[i].loadState(termStates[i + (int)this.size()]);
        }
    }

    @Override
    public TermState[] saveState() {
        TermState[] termStates = new TermState[(int)this.size() + this.dualLCQPAtoms.length];
        int i = 0;
        while ((long)i < this.size()) {
            termStates[i] = ((DualLCQPObjectiveTerm)this.get(i)).saveState();
            ++i;
        }
        for (i = 0; i < this.dualLCQPAtoms.length; ++i) {
            termStates[i + (int)this.size()] = this.dualLCQPAtoms[i].saveState();
        }
        return termStates;
    }

    @Override
    public void saveState(TermState[] termStates) {
        int i = 0;
        while ((long)i < this.size()) {
            ((DualLCQPObjectiveTerm)this.get(i)).saveState(termStates[i]);
            ++i;
        }
        for (i = 0; i < this.dualLCQPAtoms.length; ++i) {
            this.dualLCQPAtoms[i].saveState(termStates[i + (int)this.size()]);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.dualLCQPAtoms = null;
    }

    @Override
    public void close() {
        super.close();
        this.dualLCQPAtoms = null;
    }
}

