/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.sgd.term;

import java.nio.ByteBuffer;
import org.linqs.psl.model.rule.AbstractRule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.streaming.StreamingTerm;

public class SGDObjectiveTerm
extends StreamingTerm {
    public SGDObjectiveTerm(WeightedRule rule, boolean squared, boolean hinge, Hyperplane hyperplane) {
        super(hyperplane, rule, squared, hinge, null);
    }

    @Override
    public int fixedByteSize() {
        int bitSize = 96 + this.size * 64;
        return bitSize / 8;
    }

    @Override
    public void writeFixedValues(ByteBuffer fixedBuffer) {
        fixedBuffer.put((byte)(this.squared ? 1 : 0));
        fixedBuffer.put((byte)(this.hinge ? 1 : 0));
        fixedBuffer.putInt(this.rule.hashCode());
        fixedBuffer.putFloat(this.constant);
        fixedBuffer.putShort(this.size);
        for (int i = 0; i < this.size; ++i) {
            fixedBuffer.putFloat(this.coefficients[i]);
            fixedBuffer.putInt(this.atomIndexes[i]);
        }
    }

    @Override
    public void read(ByteBuffer fixedBuffer) {
        this.squared = fixedBuffer.get() == 1;
        this.hinge = fixedBuffer.get() == 1;
        this.rule = (WeightedRule)AbstractRule.getRule(fixedBuffer.getInt());
        this.constant = fixedBuffer.getFloat();
        this.size = fixedBuffer.getShort();
        if (this.coefficients.length < this.size) {
            this.coefficients = new float[this.size];
            this.atomIndexes = new int[this.size];
        }
        for (int i = 0; i < this.size; ++i) {
            this.coefficients[i] = fixedBuffer.getFloat();
            this.atomIndexes[i] = fixedBuffer.getInt();
        }
    }
}

