/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.sgd.term;

import java.util.Collection;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.sgd.term.SGDObjectiveTerm;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.TermGenerator;
import org.linqs.psl.util.Logger;

public class SGDTermGenerator
extends TermGenerator<SGDObjectiveTerm> {
    private static final Logger log = Logger.getLogger(SGDTermGenerator.class);
    private boolean warnOnConstraint;

    public SGDTermGenerator() {
        this(true, true);
    }

    public SGDTermGenerator(boolean mergeConstants, boolean warnOnConstraint) {
        super(mergeConstants);
        this.warnOnConstraint = warnOnConstraint;
    }

    public void setWarnOnConstraint(boolean warn) {
        this.warnOnConstraint = warn;
    }

    @Override
    public int createLossTerm(Collection<SGDObjectiveTerm> newTerms, boolean isHinge, boolean isSquared, GroundRule groundRule, Hyperplane hyperplane) {
        newTerms.add(new SGDObjectiveTerm(((WeightedGroundRule)groundRule).getRule(), isSquared, isHinge, hyperplane));
        return 1;
    }

    @Override
    public int createLinearConstraintTerm(Collection<SGDObjectiveTerm> newTerms, GroundRule groundRule, Hyperplane hyperplane, FunctionComparator comparator) {
        if (this.warnOnConstraint) {
            log.warn("SGD does not support hard constraints, i.e. " + groundRule);
            this.warnOnConstraint = false;
        }
        return 0;
    }
}

