/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term;

import org.linqs.psl.database.AtomStore;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.TermState;
import org.linqs.psl.util.MathUtils;

public class ReasonerTerm {
    public final TermType termType;
    protected FunctionComparator comparator;
    protected Rule rule;
    protected int[] atomIndexes;
    protected short size;
    protected float[] coefficients;
    protected float constant;
    protected boolean squared;
    protected boolean hinge;

    public ReasonerTerm(Hyperplane hyperplane, Rule rule, boolean squared, boolean hinge, FunctionComparator comparator) {
        this.rule = rule;
        this.comparator = comparator;
        this.squared = squared;
        this.hinge = hinge;
        this.termType = this.getTermType();
        this.size = (short)hyperplane.size();
        this.coefficients = hyperplane.getCoefficients();
        this.constant = hyperplane.getConstant();
        this.atomIndexes = new int[this.size];
        GroundAtom[] atoms = hyperplane.getVariables();
        for (int i = 0; i < this.size; ++i) {
            this.atomIndexes[i] = atoms[i].getIndex();
        }
    }

    private TermType getTermType() {
        if (this.comparator != null) {
            return TermType.LinearConstraintTerm;
        }
        if (!this.squared && !this.hinge) {
            return TermType.LinearLossTerm;
        }
        if (!this.squared && this.hinge) {
            return TermType.HingeLossTerm;
        }
        if (this.squared && !this.hinge) {
            return TermType.SquaredLinearLossTerm;
        }
        if (this.squared && this.hinge) {
            return TermType.SquaredHingeLossTerm;
        }
        throw new IllegalStateException("Unknown term type.");
    }

    public int size() {
        return this.size;
    }

    public Rule getRule() {
        return this.rule;
    }

    public float getWeight() {
        if (this.rule != null && this.rule.isWeighted()) {
            return ((WeightedRule)this.rule).getWeight();
        }
        return Float.POSITIVE_INFINITY;
    }

    public boolean isActive() {
        if (this.rule != null) {
            return this.rule.isActive();
        }
        return true;
    }

    public float getConstant() {
        return this.constant;
    }

    public int[] getAtomIndexes() {
        return this.atomIndexes;
    }

    public float[] getCoefficients() {
        return this.coefficients;
    }

    public boolean isConstraint() {
        return this.termType.equals((Object)TermType.LinearConstraintTerm);
    }

    public float evaluate(float[] variableValues) {
        float incompatibility = this.evaluateIncompatibility(variableValues);
        if (this.isConstraint()) {
            if (incompatibility > 0.0f) {
                return Float.POSITIVE_INFINITY;
            }
            return 0.0f;
        }
        return this.getWeight() * incompatibility;
    }

    public float evaluateIncompatibility(float[] variableValues) {
        switch (this.termType) {
            case LinearConstraintTerm: {
                return this.evaluateConstraint(variableValues);
            }
            case LinearLossTerm: {
                return this.evaluateLinearLoss(variableValues);
            }
            case HingeLossTerm: {
                return this.evaluateHingeLoss(variableValues);
            }
            case SquaredLinearLossTerm: {
                return this.evaluateSquaredLinearLoss(variableValues);
            }
            case SquaredHingeLossTerm: {
                return this.evaluateSquaredHingeLoss(variableValues);
            }
        }
        throw new IllegalStateException("Unknown term type.");
    }

    protected float evaluateConstraint(float[] variableValues) {
        float value = this.computeInnerPotential(variableValues);
        if (this.comparator.equals((Object)FunctionComparator.EQ)) {
            if (MathUtils.isZero((double)value, 0.005)) {
                return 0.0f;
            }
            return Float.POSITIVE_INFINITY;
        }
        if (this.comparator.equals((Object)FunctionComparator.LTE)) {
            if ((double)value <= 0.005) {
                return 0.0f;
            }
            return Float.POSITIVE_INFINITY;
        }
        if (this.comparator.equals((Object)FunctionComparator.GTE)) {
            if ((double)value >= -0.005) {
                return 0.0f;
            }
            return Float.POSITIVE_INFINITY;
        }
        throw new IllegalStateException("Unknown comparison function.");
    }

    protected float evaluateLinearLoss(float[] variableValues) {
        return this.computeInnerPotential(variableValues);
    }

    protected float evaluateHingeLoss(float[] variableValues) {
        return Math.max(0.0f, this.computeInnerPotential(variableValues));
    }

    protected float evaluateSquaredLinearLoss(float[] variableValues) {
        return (float)Math.pow(this.computeInnerPotential(variableValues), 2.0);
    }

    public float evaluateSquaredHingeLoss(float[] variableValues) {
        return (float)Math.pow(Math.max(0.0f, this.computeInnerPotential(variableValues)), 2.0);
    }

    public float computeInnerPotential(float[] variableValues) {
        float value = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            value += this.coefficients[i] * variableValues[this.atomIndexes[i]];
        }
        return value - this.constant;
    }

    public float computeVariablePartial(int varId, float innerPotential) {
        switch (this.termType) {
            case LinearConstraintTerm: {
                return this.getWeight() * this.computeLinearConstraintPartial(varId);
            }
            case LinearLossTerm: {
                return this.getWeight() * this.computeLinearLossPartial(varId);
            }
            case HingeLossTerm: {
                return this.getWeight() * this.computeHingeLossPartial(varId, innerPotential);
            }
            case SquaredLinearLossTerm: {
                return this.getWeight() * this.computeSquaredLinearLossPartial(varId, innerPotential);
            }
            case SquaredHingeLossTerm: {
                return this.getWeight() * this.computeSquaredHingeLossPartial(varId, innerPotential);
            }
        }
        throw new IllegalStateException("Unknown term type.");
    }

    protected float computeLinearConstraintPartial(int varId) {
        return this.coefficients[varId];
    }

    protected float computeLinearLossPartial(int varId) {
        return this.coefficients[varId];
    }

    protected float computeHingeLossPartial(int varId, float innerPotential) {
        if (innerPotential <= 0.0f) {
            return 0.0f;
        }
        return this.coefficients[varId];
    }

    protected float computeSquaredLinearLossPartial(int varId, float innerPotential) {
        return 2.0f * innerPotential * this.coefficients[varId];
    }

    protected float computeSquaredHingeLossPartial(int varId, float innerPotential) {
        if (innerPotential <= 0.0f) {
            return 0.0f;
        }
        return 2.0f * innerPotential * this.coefficients[varId];
    }

    public void loadState(TermState termState) {
    }

    public TermState saveState() {
        return new TermState();
    }

    public void saveState(TermState termState) {
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(AtomStore atomStore) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getWeight());
        builder.append(" * ");
        if (this.hinge) {
            builder.append("max(0.0, ");
        } else {
            builder.append("(");
        }
        for (int i = 0; i < this.size; ++i) {
            builder.append("(");
            builder.append(this.coefficients[i]);
            if (atomStore == null) {
                builder.append(" * <index:");
                builder.append(this.atomIndexes[i]);
                builder.append(">)");
            } else {
                builder.append(" * ");
                builder.append(atomStore.getAtomValue(this.atomIndexes[i]));
                builder.append(")");
            }
            if (i == this.size - 1) continue;
            builder.append(" + ");
        }
        builder.append(" - ");
        builder.append(this.constant);
        builder.append(")");
        if (this.squared) {
            builder.append(" ^2");
        }
        return builder.toString();
    }

    public static enum TermType {
        LinearConstraintTerm,
        LinearLossTerm,
        HingeLossTerm,
        SquaredLinearLossTerm,
        SquaredHingeLossTerm;

    }
}

